package ar.com.sdd.ebfapi.client.model.contrato.inba;

public interface InBaConstants {

    enum CodigosRespuesta {

        C000("000", "Alta de Deuda Procesada correctamente"),
        C001("001", "Modificación de Deuda Procesada correctamente"),
        C002("002", "Error de Datos (Se devuelve cuando algunos de los datos obligatorios no se informa)"),
        C003("003", "Cuit de Vendedor inválido"),
        C004("004", "Identificador de deuda inválido"),
        C005("005", "Cuit Vendedor inexistente"),
        C006("006", "Identificador cuenta de recaudación inexistente"),
        C007("007", "Moneda inválida"),
        C008("008", "Importe inválido (Cualquiera de los 3 importes)"),
        C009("009", "Fecha inválida (Cualquiera de los 3 vencimientos)"),
        C012("012", "Moneda Cuenta Recaudación distinta a Moneda informada"),
        C016("016", "Recaudadora inexistente"),
        C017("017", "Recaudadora no habilitada para publicar deuda"),
        C085("085", "No posee los permisos de preconfección"),
        C999("999", "Error General (cualquier otro error no manejado, que no es ninguno de los anteriores)"),
        ;

        private String code;
        private String desc;

        CodigosRespuesta(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }
}
