package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TableEbfApi implements Serializable {

    private List<List<CellEbfApi>> rows;

    public TableEbfApi() {
        rows = new ArrayList<>();
    }

    public void addRow(List<CellEbfApi> columns) {
        rows.add(columns);
    }

    public List<List<CellEbfApi>> getRows() {
        return rows;
    }

    public void setRows(List<List<CellEbfApi>> rows) {
        this.rows = rows;
    }

    @Override
    public String toString() {
        return "TableEbfApi ["
                + ((rows != null) ? "rows=" + Arrays.toString(rows.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TableEbfApi that = (TableEbfApi) o;

        return rows != null ? rows.equals(that.rows) : that.rows == null;
    }

    @Override
    public int hashCode() {
        return rows != null ? rows.hashCode() : 0;
    }
}
