package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocument implements Serializable {

    public enum ErpStatus {
        CREATE,
        UPDATE,
        DELETE
    }

    private String ownerType;
    private String ownerCode;
    private String payerCuit;
    private String payerCode;
    private String operatorEmail;
    private String operatorName;
    private String operatorDescription;
    private String ownerDocRef;
    private String legalDocRef;
    private String currency;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private String finalCurrency;
    private BigDecimal finalDueAmount;
    private String comments;
    private ErpStatus erpStatus;
    private String accountCode;
    private String areaCode;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creationDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate;

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerCode() {
        return ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getOperatorEmail() {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.operatorEmail = operatorEmail;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorDescription() {
        return operatorDescription;
    }

    public void setOperatorDescription(String operatorDescription) {
        this.operatorDescription = operatorDescription;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getFinalCurrency() {
        return finalCurrency;
    }

    public void setFinalCurrency(String finalCurrency) {
        this.finalCurrency = finalCurrency;
    }

    public BigDecimal getFinalDueAmount() {
        return finalDueAmount;
    }

    public void setFinalDueAmount(BigDecimal finalDueAmount) {
        this.finalDueAmount = finalDueAmount;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public ErpStatus getErpStatus() {
        return erpStatus;
    }

    public void setErpStatus(ErpStatus erpStatus) {
        this.erpStatus = erpStatus;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public String toString() {
        return "ErpDocument ["
                + ((ownerType != null) ? "ownerType=" + ownerType + ", " : "")
                + ((ownerCode != null) ? "ownerCode=" + ownerCode + ", " : "")
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((operatorEmail != null) ? "operatorEmail=" + operatorEmail + ", " : "")
                + ((operatorName != null) ? "operatorName=" + operatorName + ", " : "")
                + ((operatorDescription != null) ? "operatorDescription=" + operatorDescription + ", " : "")
                + ((ownerDocRef != null) ? "ownerDocRef=" + ownerDocRef + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((currency != null) ? "currency=" + currency + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "")
                + ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "")
                + ((finalCurrency != null) ? "finalCurrency=" + finalCurrency + ", " : "")
                + ((finalDueAmount != null) ? "finalDueAmount=" + finalDueAmount + ", " : "")
                + ((comments != null) ? "comments=" + comments + ", " : "")
                + ((erpStatus != null) ? "erpStatus=" + erpStatus + ", " : "")
                + ((accountCode != null) ? "accountCode=" + accountCode + ", " : "")
                + ((areaCode != null) ? "areaCode=" + areaCode + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErpDocument that = (ErpDocument) o;

        if (ownerType != null ? !ownerType.equals(that.ownerType) : that.ownerType != null) return false;
        if (ownerCode != null ? !ownerCode.equals(that.ownerCode) : that.ownerCode != null) return false;
        if (payerCuit != null ? !payerCuit.equals(that.payerCuit) : that.payerCuit != null) return false;
        if (payerCode != null ? !payerCode.equals(that.payerCode) : that.payerCode != null) return false;
        if (operatorEmail != null ? !operatorEmail.equals(that.operatorEmail) : that.operatorEmail != null) return false;
        if (operatorName != null ? !operatorName.equals(that.operatorName) : that.operatorName != null) return false;
        if (operatorDescription != null ? !operatorDescription.equals(that.operatorDescription) : that.operatorDescription != null) return false;
        if (ownerDocRef != null ? !ownerDocRef.equals(that.ownerDocRef) : that.ownerDocRef != null) return false;
        if (legalDocRef != null ? !legalDocRef.equals(that.legalDocRef) : that.legalDocRef != null) return false;
        if (currency != null ? !currency.equals(that.currency) : that.currency != null) return false;
        if (totalAmount != null ? !totalAmount.equals(that.totalAmount) : that.totalAmount != null) return false;
        if (dueAmount != null ? !dueAmount.equals(that.dueAmount) : that.dueAmount != null) return false;
        if (finalCurrency != null ? !finalCurrency.equals(that.finalCurrency) : that.finalCurrency != null) return false;
        if (finalDueAmount != null ? !finalDueAmount.equals(that.finalDueAmount) : that.finalDueAmount != null) return false;
        if (comments != null ? !comments.equals(that.comments) : that.comments != null) return false;
        if (erpStatus != that.erpStatus) return false;
        if (accountCode != null ? !accountCode.equals(that.accountCode) : that.accountCode != null) return false;
        if (areaCode != null ? !areaCode.equals(that.areaCode) : that.areaCode != null) return false;
        if (creationDate != null ? !creationDate.equals(that.creationDate) : that.creationDate != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        return dueDate != null ? dueDate.equals(that.dueDate) : that.dueDate == null;
    }

    @Override
    public int hashCode() {
        int result = ownerType != null ? ownerType.hashCode() : 0;
        result = 31 * result + (ownerCode != null ? ownerCode.hashCode() : 0);
        result = 31 * result + (payerCuit != null ? payerCuit.hashCode() : 0);
        result = 31 * result + (payerCode != null ? payerCode.hashCode() : 0);
        result = 31 * result + (operatorEmail != null ? operatorEmail.hashCode() : 0);
        result = 31 * result + (operatorName != null ? operatorName.hashCode() : 0);
        result = 31 * result + (operatorDescription != null ? operatorDescription.hashCode() : 0);
        result = 31 * result + (ownerDocRef != null ? ownerDocRef.hashCode() : 0);
        result = 31 * result + (legalDocRef != null ? legalDocRef.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (totalAmount != null ? totalAmount.hashCode() : 0);
        result = 31 * result + (dueAmount != null ? dueAmount.hashCode() : 0);
        result = 31 * result + (finalCurrency != null ? finalCurrency.hashCode() : 0);
        result = 31 * result + (finalDueAmount != null ? finalDueAmount.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        result = 31 * result + (erpStatus != null ? erpStatus.hashCode() : 0);
        result = 31 * result + (accountCode != null ? accountCode.hashCode() : 0);
        result = 31 * result + (areaCode != null ? areaCode.hashCode() : 0);
        result = 31 * result + (creationDate != null ? creationDate.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        return result;
    }
}
