package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DocumentEbfApiSet implements Serializable {

    private Long totalPages;
    private Long totalElements;
    private List<DocumentEbfApi> documentEbfApiList;

    public Long getTotalPages() {
        return totalPages;
    }

    public void setTotalPages(Long totalPages) {
        this.totalPages = totalPages;
    }

    public Long getTotalElements() {
        return totalElements;
    }

    public void setTotalElements(Long totalElements) {
        this.totalElements = totalElements;
    }

    public List<DocumentEbfApi> getDocumentEbfApiList() {
        return documentEbfApiList;
    }

    public void setDocumentEbfApiList(List<DocumentEbfApi> documentEbfApiList) {
        this.documentEbfApiList = documentEbfApiList;
    }

    @Override
    public String toString() {
        return "DocumentEbfApiSet ["
                + ((totalPages != null) ? "totalPages=" + totalPages + ", " : "")
                + ((totalElements != null) ? "totalElements=" + totalElements + ", " : "")
                + ((documentEbfApiList != null) ? "documentEbfApiList=" + Arrays.toString(documentEbfApiList.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DocumentEbfApiSet that = (DocumentEbfApiSet) o;

        if (totalPages != null ? !totalPages.equals(that.totalPages) : that.totalPages != null) return false;
        if (totalElements != null ? !totalElements.equals(that.totalElements) : that.totalElements != null) return false;
        return documentEbfApiList != null ? documentEbfApiList.equals(that.documentEbfApiList) : that.documentEbfApiList == null;
    }

    @Override
    public int hashCode() {
        int result = totalPages != null ? totalPages.hashCode() : 0;
        result = 31 * result + (totalElements != null ? totalElements.hashCode() : 0);
        result = 31 * result + (documentEbfApiList != null ? documentEbfApiList.hashCode() : 0);
        return result;
    }
}
