package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentDocumentEbfApiSet implements Serializable {

    private Long totalPages;
    private Long totalElements;
    private List<PaymentDocumentEbfApi> paymentDocumentEbfApiList;

    public Long getTotalPages() {
        return totalPages;
    }

    public void setTotalPages(Long totalPages) {
        this.totalPages = totalPages;
    }

    public Long getTotalElements() {
        return totalElements;
    }

    public void setTotalElements(Long totalElements) {
        this.totalElements = totalElements;
    }

    public List<PaymentDocumentEbfApi> getPaymentDocumentEbfApiList() {
        return paymentDocumentEbfApiList;
    }

    public void setPaymentDocumentEbfApiList(List<PaymentDocumentEbfApi> paymentDocumentEbfApiList) {
        this.paymentDocumentEbfApiList = paymentDocumentEbfApiList;
    }

    @Override
    public String toString() {
        return "PaymentDocumentEbfApiSet ["
                + ((totalPages != null) ? "totalPages=" + totalPages + ", " : "")
                + ((totalElements != null) ? "totalElements=" + totalElements + ", " : "")
                + ((paymentDocumentEbfApiList != null) ? "paymentDocumentEbfApiList=" + Arrays.toString(paymentDocumentEbfApiList.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentDocumentEbfApiSet that = (PaymentDocumentEbfApiSet) o;

        if (totalPages != null ? !totalPages.equals(that.totalPages) : that.totalPages != null) return false;
        if (totalElements != null ? !totalElements.equals(that.totalElements) : that.totalElements != null) return false;
        return paymentDocumentEbfApiList != null ? paymentDocumentEbfApiList.equals(that.paymentDocumentEbfApiList) : that.paymentDocumentEbfApiList == null;
    }

    @Override
    public int hashCode() {
        int result = totalPages != null ? totalPages.hashCode() : 0;
        result = 31 * result + (totalElements != null ? totalElements.hashCode() : 0);
        result = 31 * result + (paymentDocumentEbfApiList != null ? paymentDocumentEbfApiList.hashCode() : 0);
        return result;
    }
}
