package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CompanyAccountEbfApi implements Serializable {

    private Long id;
    private String description;
    private String externalReference;
    private CompanyEbfApi accountOwner;
    private BankEbfApi bank;
    private String csExternalReference;
    private String branchCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public CompanyEbfApi getAccountOwner() {
        return accountOwner;
    }

    public void setAccountOwner(CompanyEbfApi accountOwner) {
        this.accountOwner = accountOwner;
    }

    public BankEbfApi getBank() {
        return bank;
    }

    public void setBank(BankEbfApi bank) {
        this.bank = bank;
    }

    public String getCsExternalReference() {
        return csExternalReference;
    }

    public void setCsExternalReference(String csExternalReference) {
        this.csExternalReference = csExternalReference;
    }

    public String getBranchCode() {
        return branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    @Override
    public String toString() {
        return "CompanyAccountEbfApi ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((externalReference != null) ? "externalReference=" + externalReference + ", " : "")
                + ((accountOwner != null) ? "accountOwner=" + accountOwner + ", " : "")
                + ((bank != null) ? "bank=" + bank + ", " : "")
                + ((csExternalReference != null) ? "csExternalReference=" + csExternalReference + ", " : "")
                + ((branchCode != null) ? "branchCode=" + branchCode : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CompanyAccountEbfApi that = (CompanyAccountEbfApi) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (description != null ? !description.equals(that.description) : that.description != null) return false;
        if (externalReference != null ? !externalReference.equals(that.externalReference) : that.externalReference != null) return false;
        if (accountOwner != null ? !accountOwner.equals(that.accountOwner) : that.accountOwner != null) return false;
        if (bank != null ? !bank.equals(that.bank) : that.bank != null) return false;
        if (csExternalReference != null ? !csExternalReference.equals(that.csExternalReference) : that.csExternalReference != null) return false;
        return branchCode != null ? branchCode.equals(that.branchCode) : that.branchCode == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (externalReference != null ? externalReference.hashCode() : 0);
        result = 31 * result + (accountOwner != null ? accountOwner.hashCode() : 0);
        result = 31 * result + (bank != null ? bank.hashCode() : 0);
        result = 31 * result + (csExternalReference != null ? csExternalReference.hashCode() : 0);
        result = 31 * result + (branchCode != null ? branchCode.hashCode() : 0);
        return result;
    }
}
