package ar.com.sdd.ebfapi.client.io.contrato.inba;

import ar.com.sdd.ebfapi.client.model.contrato.inba.Deuda;
import ar.com.sdd.ebfapi.client.model.contrato.inba.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeudaResponse {

    private Long identificadorDeuda;
    private Respuesta[] respuesta;
    private Deuda[] deudas;

    public Long getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(Long identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    public Respuesta[] getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta[] respuesta) {
        this.respuesta = respuesta;
    }

    public Deuda[] getDeudas() {
        return deudas;
    }

    public void setDeudas(Deuda[] deudas) {
        this.deudas = deudas;
    }

    @Override
    public String toString() {
        return "DeudaResponse ["
                + ((identificadorDeuda != null) ? "identificadorDeuda=" + identificadorDeuda + ", " : "")
                + ((respuesta != null) ? "respuesta=" + Arrays.toString(respuesta) + ", " : "")
                + ((deudas != null) ? "deudas=" + Arrays.toString(deudas) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DeudaResponse that = (DeudaResponse) o;

        if (identificadorDeuda != null ? !identificadorDeuda.equals(that.identificadorDeuda) : that.identificadorDeuda != null) return false;
        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        if (!Arrays.equals(respuesta, that.respuesta)) return false;
        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return Arrays.equals(deudas, that.deudas);
    }

    @Override
    public int hashCode() {
        int result = identificadorDeuda != null ? identificadorDeuda.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(respuesta);
        result = 31 * result + Arrays.hashCode(deudas);
        return result;
    }
}
