package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CompanyEbfApi implements Serializable {

    private Long id;
    private String name;
    private String cuit;
    private String razonSocial;
    private CompanyEbfApi collectorCompany;
    private List<CompanyEbfApi> collectedOwners;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getRazonSocial() {
        return razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    public CompanyEbfApi getCollectorCompany() {
        return collectorCompany;
    }

    public void setCollectorCompany(CompanyEbfApi collectorCompany) {
        this.collectorCompany = collectorCompany;
    }

    public List<CompanyEbfApi> getCollectedOwners() {
        return collectedOwners;
    }

    public void setCollectedOwners(List<CompanyEbfApi> collectedOwners) {
        this.collectedOwners = collectedOwners;
    }

    @Override
    public String toString() {
        return "CompanyEbfApi ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((name != null) ? "name=" + name + ", " : "")
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((razonSocial != null) ? "razonSocial=" + razonSocial + ", " : "")
                + ((collectorCompany != null) ? "collectorCompany=" + collectorCompany + ", " : "")
                + ((collectedOwners != null) ? "collectedOwners=" + Arrays.toString(collectedOwners.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CompanyEbfApi that = (CompanyEbfApi) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        if (razonSocial != null ? !razonSocial.equals(that.razonSocial) : that.razonSocial != null) return false;
        if (collectorCompany != null ? !collectorCompany.equals(that.collectorCompany) : that.collectorCompany != null) return false;
        return collectedOwners != null ? collectedOwners.equals(that.collectedOwners) : that.collectedOwners == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (razonSocial != null ? razonSocial.hashCode() : 0);
        result = 31 * result + (collectorCompany != null ? collectorCompany.hashCode() : 0);
        result = 31 * result + (collectedOwners != null ? collectedOwners.hashCode() : 0);
        return result;
    }
}
