package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpPaymentSet implements Serializable {

    private List<ErpPayment> erpPayments;

    public List<ErpPayment> getErpPayments() {
        return erpPayments;
    }

    public void setErpPayments(List<ErpPayment> erpPayments) {
        this.erpPayments = erpPayments;
    }

    @Override
    public String toString() {
        return "ErpPaymentSet ["
                + ((erpPayments != null) ? "erpPayments=" + Arrays.toString(erpPayments.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErpPaymentSet that = (ErpPaymentSet) o;

        return erpPayments != null ? erpPayments.equals(that.erpPayments) : that.erpPayments == null;
    }

    @Override
    public int hashCode() {
        return erpPayments != null ? erpPayments.hashCode() : 0;
    }
}
