package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SettlementEbfApi implements Serializable {

    private String uid;
    private String type;
    private CompanyEbfApi owner;
    private CompanyEbfApi payer;
    private String paymentDocUid;
    private CompanyAccountEbfApi ownerAccount;
    private CompanyAccountEbfApi payerAccount;
    private String status;
    private String reasonId;
    private String currencyId;
    private Date issueDate;
    private Date executionDate;
    private BigDecimal amount;
    private String observations;
    private Date achExecutionDate;
    private BigDecimal achAmount;
    private String achObservations;
    private String achDato1;
    private String achDato2;
    private String achDato3;

    //Campos extra
    private boolean selected;

    public SettlementEbfApi() {

    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }


    public CompanyEbfApi getOwner() {
        return owner;
    }

    public void setOwner(CompanyEbfApi owner) {
        this.owner = owner;
    }

    public CompanyEbfApi getPayer() {
        return payer;
    }

    public void setPayer(CompanyEbfApi payer) {
        this.payer = payer;
    }

    public String getPaymentDocUid() {
        return paymentDocUid;
    }

    public void setPaymentDocUid(String paymentDocUid) {
        this.paymentDocUid = paymentDocUid;
    }

    public CompanyAccountEbfApi getOwnerAccount() {
        return ownerAccount;
    }

    public void setOwnerAccount(CompanyAccountEbfApi ownerAccount) {
        this.ownerAccount = ownerAccount;
    }

    public CompanyAccountEbfApi getPayerAccount() {
        return payerAccount;
    }

    public void setPayerAccount(CompanyAccountEbfApi payerAccount) {
        this.payerAccount = payerAccount;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getReasonId() {
        return reasonId;
    }

    public void setReasonId(String reasonId) {
        this.reasonId = reasonId;
    }

    public String getCurrencyId() {
        return currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getExecutionDate() {
        return executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getObservations() {
        return observations;
    }

    public void setObservations(String observations) {
        this.observations = observations;
    }

    public Date getAchExecutionDate() {
        return achExecutionDate;
    }

    public void setAchExecutionDate(Date achExecutionDate) {
        this.achExecutionDate = achExecutionDate;
    }

    public BigDecimal getAchAmount() {
        return achAmount;
    }

    public void setAchAmount(BigDecimal achAmount) {
        this.achAmount = achAmount;
    }

    public String getAchObservations() {
        return achObservations;
    }

    public void setAchObservations(String achObservations) {
        this.achObservations = achObservations;
    }

    public String getAchDato1() {
        return achDato1;
    }

    public void setAchDato1(String achDato1) {
        this.achDato1 = achDato1;
    }

    public String getAchDato2() {
        return achDato2;
    }

    public void setAchDato2(String achDato2) {
        this.achDato2 = achDato2;
    }

    public String getAchDato3() {
        return achDato3;
    }

    public void setAchDato3(String achDato3) {
        this.achDato3 = achDato3;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public String toString() {
        return "SettlementEbfApi ["
                + ((uid != null) ? "uid=" + uid + ", " : "")
                + ((type != null) ? "type=" + type + ", " : "")
                + ((owner != null) ? "owner=" + owner + ", " : "")
                + ((payer != null) ? "payer=" + payer + ", " : "")
                + ((paymentDocUid != null) ? "paymentDocUid=" + paymentDocUid + ", " : "")
                + ((ownerAccount != null) ? "ownerAccount=" + ownerAccount + ", " : "")
                + ((payerAccount != null) ? "payerAccount=" + payerAccount + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((reasonId != null) ? "reasonId=" + reasonId + ", " : "")
                + ((currencyId != null) ? "currencyId=" + currencyId + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((executionDate != null) ? "executionDate=" + executionDate + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((observations != null) ? "observations=" + observations + ", " : "")
                + ((achExecutionDate != null) ? "achExecutionDate=" + achExecutionDate + ", " : "")
                + ((achAmount != null) ? "achAmount=" + achAmount + ", " : "")
                + ((achObservations != null) ? "achObservations=" + achObservations + ", " : "")
                + ((achDato1 != null) ? "achDato1=" + achDato1 + ", " : "")
                + ((achDato2 != null) ? "achDato2=" + achDato2 + ", " : "")
                + ((achDato3 != null) ? "achDato3=" + achDato3 + ", " : "")
                + "selected=" + selected
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SettlementEbfApi that = (SettlementEbfApi) o;

        if (selected != that.selected) return false;
        if (uid != null ? !uid.equals(that.uid) : that.uid != null) return false;
        if (type != null ? !type.equals(that.type) : that.type != null) return false;
        if (owner != null ? !owner.equals(that.owner) : that.owner != null) return false;
        if (payer != null ? !payer.equals(that.payer) : that.payer != null) return false;
        if (paymentDocUid != null ? !paymentDocUid.equals(that.paymentDocUid) : that.paymentDocUid != null) return false;
        if (ownerAccount != null ? !ownerAccount.equals(that.ownerAccount) : that.ownerAccount != null) return false;
        if (payerAccount != null ? !payerAccount.equals(that.payerAccount) : that.payerAccount != null) return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        if (reasonId != null ? !reasonId.equals(that.reasonId) : that.reasonId != null) return false;
        if (currencyId != null ? !currencyId.equals(that.currencyId) : that.currencyId != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (executionDate != null ? !executionDate.equals(that.executionDate) : that.executionDate != null) return false;
        if (amount != null ? !amount.equals(that.amount) : that.amount != null) return false;
        if (observations != null ? !observations.equals(that.observations) : that.observations != null) return false;
        if (achExecutionDate != null ? !achExecutionDate.equals(that.achExecutionDate) : that.achExecutionDate != null) return false;
        if (achAmount != null ? !achAmount.equals(that.achAmount) : that.achAmount != null) return false;
        if (achObservations != null ? !achObservations.equals(that.achObservations) : that.achObservations != null) return false;
        if (achDato1 != null ? !achDato1.equals(that.achDato1) : that.achDato1 != null) return false;
        if (achDato2 != null ? !achDato2.equals(that.achDato2) : that.achDato2 != null) return false;
        return achDato3 != null ? achDato3.equals(that.achDato3) : that.achDato3 == null;
    }

    @Override
    public int hashCode() {
        int result = uid != null ? uid.hashCode() : 0;
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (owner != null ? owner.hashCode() : 0);
        result = 31 * result + (payer != null ? payer.hashCode() : 0);
        result = 31 * result + (paymentDocUid != null ? paymentDocUid.hashCode() : 0);
        result = 31 * result + (ownerAccount != null ? ownerAccount.hashCode() : 0);
        result = 31 * result + (payerAccount != null ? payerAccount.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (reasonId != null ? reasonId.hashCode() : 0);
        result = 31 * result + (currencyId != null ? currencyId.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (executionDate != null ? executionDate.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (observations != null ? observations.hashCode() : 0);
        result = 31 * result + (achExecutionDate != null ? achExecutionDate.hashCode() : 0);
        result = 31 * result + (achAmount != null ? achAmount.hashCode() : 0);
        result = 31 * result + (achObservations != null ? achObservations.hashCode() : 0);
        result = 31 * result + (achDato1 != null ? achDato1.hashCode() : 0);
        result = 31 * result + (achDato2 != null ? achDato2.hashCode() : 0);
        result = 31 * result + (achDato3 != null ? achDato3.hashCode() : 0);
        result = 31 * result + (selected ? 1 : 0);
        return result;
    }
}
