package ar.com.sdd.ebfapi.client.model.dvp;

import ar.com.sdd.ebfapi.client.model.EbfApiConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DvpPaymentDocument implements Serializable {

    private String paymentUid;
    private Date creationDate;
    private Date issueDate;
    private Date creditDate;
    private String agentCode;
    private String idFce;
    private String instrumentReference;
    private String currency;
    private BigDecimal amount;
    private String issuerAccount;
    private String issuerSubAccount;
    private String collectorAccount;
    private String collectorSubAccount;
    private String paymentReference;
    private String status;
    private EbfApiConst.AckStatus ackStatus;
    private String ackStatusMessage;

    public String getPaymentUid() {
        return paymentUid;
    }

    public void setPaymentUid(String paymentUid) {
        this.paymentUid = paymentUid;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public String getAgentCode() {
        return agentCode;
    }

    public void setAgentCode(String agentCode) {
        this.agentCode = agentCode;
    }

    public String getIdFce() {
        return idFce;
    }

    public void setIdFce(String idFce) {
        this.idFce = idFce;
    }

    public String getInstrumentReference() {
        return instrumentReference;
    }

    public void setInstrumentReference(String instrumentReference) {
        this.instrumentReference = instrumentReference;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getIssuerAccount() {
        return issuerAccount;
    }

    public void setIssuerAccount(String issuerAccount) {
        this.issuerAccount = issuerAccount;
    }

    public String getIssuerSubAccount() {
        return issuerSubAccount;
    }

    public void setIssuerSubAccount(String issuerSubAccount) {
        this.issuerSubAccount = issuerSubAccount;
    }

    public String getCollectorAccount() {
        return collectorAccount;
    }

    public void setCollectorAccount(String collectorAccount) {
        this.collectorAccount = collectorAccount;
    }

    public String getCollectorSubAccount() {
        return collectorSubAccount;
    }

    public void setCollectorSubAccount(String collectorSubAccount) {
        this.collectorSubAccount = collectorSubAccount;
    }

    public String getPaymentReference() {
        return paymentReference;
    }

    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public EbfApiConst.AckStatus getAckStatus() {
        return ackStatus;
    }

    public void setAckStatus(EbfApiConst.AckStatus ackStatus) {
        this.ackStatus = ackStatus;
    }

    public String getAckStatusMessage() {
        return ackStatusMessage;
    }

    public void setAckStatusMessage(String ackStatusMessage) {
        this.ackStatusMessage = ackStatusMessage;
    }

    @Override
    public String toString() {
        return "DvpPaymentDocument ["
                + ((paymentUid != null) ? "paymentUid=" + paymentUid + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((creditDate != null) ? "creditDate=" + creditDate + ", " : "")
                + ((agentCode != null) ? "agentCode=" + agentCode + ", " : "")
                + ((idFce != null) ? "idFce=" + idFce + ", " : "")
                + ((instrumentReference != null) ? "instrumentReference=" + instrumentReference + ", " : "")
                + ((currency != null) ? "currency=" + currency + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((issuerAccount != null) ? "issuerAccount=" + issuerAccount + ", " : "")
                + ((issuerSubAccount != null) ? "issuerSubAccount=" + issuerSubAccount + ", " : "")
                + ((collectorAccount != null) ? "collectorAccount=" + collectorAccount + ", " : "")
                + ((collectorSubAccount != null) ? "collectorSubAccount=" + collectorSubAccount + ", " : "")
                + ((paymentReference != null) ? "paymentReference=" + paymentReference + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((ackStatus != null) ? "ackStatus=" + ackStatus + ", " : "")
                + ((ackStatusMessage != null) ? "ackStatusMessage=" + ackStatusMessage : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DvpPaymentDocument that = (DvpPaymentDocument) o;

        if (paymentUid != null ? !paymentUid.equals(that.paymentUid) : that.paymentUid != null) return false;
        if (creationDate != null ? !creationDate.equals(that.creationDate) : that.creationDate != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (creditDate != null ? !creditDate.equals(that.creditDate) : that.creditDate != null) return false;
        if (agentCode != null ? !agentCode.equals(that.agentCode) : that.agentCode != null) return false;
        if (idFce != null ? !idFce.equals(that.idFce) : that.idFce != null) return false;
        if (instrumentReference != null ? !instrumentReference.equals(that.instrumentReference) : that.instrumentReference != null) return false;
        if (currency != null ? !currency.equals(that.currency) : that.currency != null) return false;
        if (amount != null ? !amount.equals(that.amount) : that.amount != null) return false;
        if (issuerAccount != null ? !issuerAccount.equals(that.issuerAccount) : that.issuerAccount != null) return false;
        if (issuerSubAccount != null ? !issuerSubAccount.equals(that.issuerSubAccount) : that.issuerSubAccount != null) return false;
        if (collectorAccount != null ? !collectorAccount.equals(that.collectorAccount) : that.collectorAccount != null) return false;
        if (collectorSubAccount != null ? !collectorSubAccount.equals(that.collectorSubAccount) : that.collectorSubAccount != null) return false;
        if (paymentReference != null ? !paymentReference.equals(that.paymentReference) : that.paymentReference != null) return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        if (ackStatus != that.ackStatus) return false;
        return ackStatusMessage != null ? ackStatusMessage.equals(that.ackStatusMessage) : that.ackStatusMessage == null;
    }

    @Override
    public int hashCode() {
        int result = paymentUid != null ? paymentUid.hashCode() : 0;
        result = 31 * result + (creationDate != null ? creationDate.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (creditDate != null ? creditDate.hashCode() : 0);
        result = 31 * result + (agentCode != null ? agentCode.hashCode() : 0);
        result = 31 * result + (idFce != null ? idFce.hashCode() : 0);
        result = 31 * result + (instrumentReference != null ? instrumentReference.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (issuerAccount != null ? issuerAccount.hashCode() : 0);
        result = 31 * result + (issuerSubAccount != null ? issuerSubAccount.hashCode() : 0);
        result = 31 * result + (collectorAccount != null ? collectorAccount.hashCode() : 0);
        result = 31 * result + (collectorSubAccount != null ? collectorSubAccount.hashCode() : 0);
        result = 31 * result + (paymentReference != null ? paymentReference.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (ackStatus != null ? ackStatus.hashCode() : 0);
        result = 31 * result + (ackStatusMessage != null ? ackStatusMessage.hashCode() : 0);
        return result;
    }
}
