package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocumentSet implements Serializable {

    private List<ErpDocument> erpDocuments;

    public List<ErpDocument> getErpDocuments() {
        return erpDocuments;
    }

    public void setErpDocuments(List<ErpDocument> erpDocuments) {
        this.erpDocuments = erpDocuments;
    }

    @Override
    public String toString() {
        return "ErpDocumentSet ["
                + ((erpDocuments != null) ? "erpDocuments=" + Arrays.toString(erpDocuments.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErpDocumentSet that = (ErpDocumentSet) o;

        return erpDocuments != null ? erpDocuments.equals(that.erpDocuments) : that.erpDocuments == null;
    }

    @Override
    public int hashCode() {
        return erpDocuments != null ? erpDocuments.hashCode() : 0;
    }
}
