package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpCompanySet implements Serializable {

    public enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),

        INCREMENTAL("INCREMENTAL");

        private String value;

        PublicationModeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate;
    private PublicationModeEnum publicationMode;
    private List<ErpCompany> customers;

    @JsonProperty("processDate")
    @NotNull
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @JsonProperty("publicationMode")
    @NotNull
    public PublicationModeEnum getPublicationMode() {
        return publicationMode;
    }

    public void setPublicationMode(PublicationModeEnum publicationMode) {
        this.publicationMode = publicationMode;
    }

    @JsonProperty("customers")
    public List<ErpCompany> getCustomers() {
        return customers;
    }

    public void setCustomers(List<ErpCompany> customers) {
        this.customers = customers;
    }

    @Override
    public String toString() {
        return "ErpCompanySet ["
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((publicationMode != null) ? "publicationMode=" + publicationMode + ", " : "")
                + ((customers != null) ? "customers=" + Arrays.toString(customers.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpCompanySet that = (ErpCompanySet) o;
        return Objects.equals(processDate, that.processDate) && Objects.equals(publicationMode, that.publicationMode) && Objects.equals(customers, that.customers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(processDate, publicationMode, customers);
    }
}