package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OperatorEbfApi implements Serializable {

    private String uid;
    private String name;
    private String description;
    private String externalSystemReference;
    private String email;
    private String status;
    private CompanyEbfApi companyEbfApi;
    private Date lastModificationTimestamp;
    private String csFormVersion;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalSystemReference() {
        return externalSystemReference;
    }

    public void setExternalSystemReference(String externalSystemReference) {
        this.externalSystemReference = externalSystemReference;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public CompanyEbfApi getCompanyEbfApi() {
        return companyEbfApi;
    }

    public void setCompanyEbfApi(CompanyEbfApi companyEbfApi) {
        this.companyEbfApi = companyEbfApi;
    }

    public Date getLastModificationTimestamp() {
        return lastModificationTimestamp;
    }

    public void setLastModificationTimestamp(Date lastModificationTimestamp) {
        this.lastModificationTimestamp = lastModificationTimestamp;
    }

    public String getCsFormVersion() {
        return csFormVersion;
    }

    public void setCsFormVersion(String csFormVersion) {
        this.csFormVersion = csFormVersion;
    }

    @Override
    public String toString() {
        return "OperatorEbfApi ["
                + ((uid != null) ? "uid=" + uid + ", " : "")
                + ((name != null) ? "name=" + name + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((externalSystemReference != null) ? "externalSystemReference=" + externalSystemReference + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((companyEbfApi != null) ? "companyEbfApi=" + companyEbfApi + ", " : "")
                + ((lastModificationTimestamp != null) ? "lastModificationTimestamp=" + lastModificationTimestamp + ", " : "")
                + ((csFormVersion != null) ? "csFormVersion=" + csFormVersion : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OperatorEbfApi that = (OperatorEbfApi) o;

        if (uid != null ? !uid.equals(that.uid) : that.uid != null) return false;
        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        if (description != null ? !description.equals(that.description) : that.description != null) return false;
        if (externalSystemReference != null ? !externalSystemReference.equals(that.externalSystemReference) : that.externalSystemReference != null) return false;
        if (email != null ? !email.equals(that.email) : that.email != null) return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        if (companyEbfApi != null ? !companyEbfApi.equals(that.companyEbfApi) : that.companyEbfApi != null) return false;
        if (lastModificationTimestamp != null ? !lastModificationTimestamp.equals(that.lastModificationTimestamp) : that.lastModificationTimestamp != null) return false;
        return csFormVersion != null ? csFormVersion.equals(that.csFormVersion) : that.csFormVersion == null;
    }

    @Override
    public int hashCode() {
        int result = uid != null ? uid.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (externalSystemReference != null ? externalSystemReference.hashCode() : 0);
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (companyEbfApi != null ? companyEbfApi.hashCode() : 0);
        result = 31 * result + (lastModificationTimestamp != null ? lastModificationTimestamp.hashCode() : 0);
        result = 31 * result + (csFormVersion != null ? csFormVersion.hashCode() : 0);
        return result;
    }
}
