package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocumentCommentDetail implements  Serializable{
  private String order = "";
  private String ownerType;
  private String relatedOwnerDocRef = "";
  private String clearingOwnerDocRef = "";
  private String relatedLegalDocRef = "";
  @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'", timezone = "GMT+00:00")
  private Date  issueDate;
  @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'", timezone = "GMT+00:00")
  private Date  dueDate;
  private BigDecimal dueAmount;
  private BigDecimal dueAmountUSD;
  private BigDecimal dueAmountRate;
  private BigDecimal differenceAmount;
  private String comments = "";

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getRelatedOwnerDocRef() {
        return relatedOwnerDocRef;
    }

    public void setRelatedOwnerDocRef(String relatedOwnerDocRef) {
        this.relatedOwnerDocRef = relatedOwnerDocRef;
    }

    public String getClearingOwnerDocRef() {
        return clearingOwnerDocRef;
    }

    public void setClearingOwnerDocRef(String clearingOwnerDocRef) {
        this.clearingOwnerDocRef = clearingOwnerDocRef;
    }

    public String getRelatedLegalDocRef() {
        return relatedLegalDocRef;
    }

    public void setRelatedLegalDocRef(String relatedLegalDocRef) {
        this.relatedLegalDocRef = relatedLegalDocRef;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public BigDecimal getDueAmountUSD() {
        return dueAmountUSD;
    }

    public void setDueAmountUSD(BigDecimal dueAmountUSD) {
        this.dueAmountUSD = dueAmountUSD;
    }

    public BigDecimal getDueAmountRate() {
        return dueAmountRate;
    }

    public void setDueAmountRate(BigDecimal dueAmountRate) {
        this.dueAmountRate = dueAmountRate;
    }

    public BigDecimal getDifferenceAmount() {
        return differenceAmount;
    }

    public void setDifferenceAmount(BigDecimal differenceAmount) {
        this.differenceAmount = differenceAmount;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErpDocumentCommentDetail that = (ErpDocumentCommentDetail) o;

        if (!Objects.equals(order, that.order)) return false;
        if (!Objects.equals(ownerType, that.ownerType)) return false;
        if (!Objects.equals(relatedOwnerDocRef, that.relatedOwnerDocRef)) return false;
        if (!Objects.equals(clearingOwnerDocRef, that.clearingOwnerDocRef)) return false;
        if (!Objects.equals(relatedLegalDocRef, that.relatedLegalDocRef)) return false;
        if (!Objects.equals(issueDate, that.issueDate)) return false;
        if (!Objects.equals(dueDate, that.dueDate)) return false;
        if (!Objects.equals(dueAmount, that.dueAmount)) return false;
        if (!Objects.equals(dueAmountUSD, that.dueAmountUSD)) return false;
        if (!Objects.equals(dueAmountRate, that.dueAmountRate)) return false;
        if (!Objects.equals(differenceAmount, that.differenceAmount)) return false;
        return Objects.equals(comments, that.comments);
    }

    @Override
    public int hashCode() {
        int result = order != null ? order.hashCode() : 0;
        result = 31 * result + (ownerType != null ? ownerType.hashCode() : 0);
        result = 31 * result + (relatedOwnerDocRef != null ? relatedOwnerDocRef.hashCode() : 0);
        result = 31 * result + (clearingOwnerDocRef != null ? clearingOwnerDocRef.hashCode() : 0);
        result = 31 * result + (relatedLegalDocRef != null ? relatedLegalDocRef.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (dueAmount != null ? dueAmount.hashCode() : 0);
        result = 31 * result + (dueAmountUSD != null ? dueAmountUSD.hashCode() : 0);
        result = 31 * result + (dueAmountRate != null ? dueAmountRate.hashCode() : 0);
        result = 31 * result + (differenceAmount != null ? differenceAmount.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ErpDocumentCommentDetail [" +
                "order=" + order +
                ", ownerType=" + ownerType +
                ", relatedOwnerDocRef=" + relatedOwnerDocRef +
                ", clearingOwnerDocRef=" + clearingOwnerDocRef +
                ", relatedLegalDocRef=" + relatedLegalDocRef +
                ", issueDate=" + issueDate +
                ", dueDate=" + dueDate +
                ", dueAmount=" + dueAmount +
                ", dueAmountUSD=" + dueAmountUSD +
                ", dueAmountRate=" + dueAmountRate +
                ", differenceAmount=" + differenceAmount +
                ", comments=" + comments +
                ']';
    }
}

