package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocumentCommentSet implements Serializable{

    public enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),

        INCREMENTAL("INCREMENTAL");

        private String value;

        PublicationModeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private String trackingNumber;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate;
    private PublicationModeEnum publicationMode;
    private Double exchangeRate;
    private List<ErpDocumentComment> erpDocumentComments;

    @Size(max = 20)
    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @Size(max = 10)
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @Size(max = 20)
    public PublicationModeEnum getPublicationMode() {
        return publicationMode;
    }

    public void setPublicationMode(PublicationModeEnum publicationMode) {
        this.publicationMode = publicationMode;
    }









    public List<ErpDocumentComment> getErpDocumentComments() {
    return erpDocumentComments;
  }


  public void setErpDocumentComments(List<ErpDocumentComment> erpDocumentComments) {
    this.erpDocumentComments = erpDocumentComments;
  }

    @Override
    public String toString() {
        return "ErpDocumentCommentSet [" +
                "trackingNumber=" + trackingNumber +
                ", processDate=" + processDate +
                ", publicationMode=" + publicationMode +
                ", exchangeRate=" + exchangeRate +
                ", erpDocumentComments=" + (erpDocumentComments == null ? erpDocumentComments : Arrays.toString(erpDocumentComments.toArray())) +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpDocumentCommentSet that = (ErpDocumentCommentSet) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(processDate, that.processDate) && publicationMode == that.publicationMode && Objects.equals(exchangeRate, that.exchangeRate) && Objects.equals(erpDocumentComments, that.erpDocumentComments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, processDate, publicationMode, exchangeRate, erpDocumentComments);
    }
}

