package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BankAccountEbfApi implements Serializable {

    private String cuit;
    private String unifiedBankReference;
    private String alias;
    private String description;
    private String bankCode;
    private String branchCode;

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getUnifiedBankReference() {
        return unifiedBankReference;
    }

    public void setUnifiedBankReference(String unifiedBankReference) {
        this.unifiedBankReference = unifiedBankReference;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBranchCode() {
        return branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    @Override
    public String toString() {
        return "BankAccountEbfApi ["
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((unifiedBankReference != null) ? "unifiedBankReference=" + unifiedBankReference + ", " : "")
                + ((alias != null) ? "alias=" + alias + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((bankCode != null) ? "bankCode=" + bankCode + ", " : "")
                + ((branchCode != null) ? "branchCode=" + branchCode : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        BankAccountEbfApi that = (BankAccountEbfApi) o;

        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        if (unifiedBankReference != null ? !unifiedBankReference.equals(that.unifiedBankReference) : that.unifiedBankReference != null) return false;
        if (alias != null ? !alias.equals(that.alias) : that.alias != null) return false;
        if (description != null ? !description.equals(that.description) : that.description != null) return false;
        if (bankCode != null ? !bankCode.equals(that.bankCode) : that.bankCode != null) return false;
        return branchCode != null ? branchCode.equals(that.branchCode) : that.branchCode == null;
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (unifiedBankReference != null ? unifiedBankReference.hashCode() : 0);
        result = 31 * result + (alias != null ? alias.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (bankCode != null ? bankCode.hashCode() : 0);
        result = 31 * result + (branchCode != null ? branchCode.hashCode() : 0);
        return result;
    }
}
