package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpBussinesUnit implements Serializable {

    private String biller;
    private String payerCode;
    private String shiptoCode;

    @JsonProperty("biller")
    @Size(max = 4)
    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    @JsonProperty("payerCode")
    @Size(max = 10)
    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    @JsonProperty("shiptoCode")
    @Size(max = 10)
    public String getShiptoCode() {
        return shiptoCode;
    }

    public void setShiptoCode(String shiptoCode) {
        this.shiptoCode = shiptoCode;
    }

    @Override
    public String toString() {
        return "ErpBussinesUnit ["
                + ((biller != null) ? "biller=" + biller + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((shiptoCode != null) ? "shiptoCode=" + shiptoCode : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpBussinesUnit erpBussinesUnit = (ErpBussinesUnit) o;
        return Objects.equals(biller, erpBussinesUnit.biller) && Objects.equals(payerCode, erpBussinesUnit.payerCode) && Objects.equals(shiptoCode, erpBussinesUnit.shiptoCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(biller, payerCode, shiptoCode);
    }
}