package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpCompany implements Serializable {

    private String taxId;
    private String name;
    private String addressStreet;
    private String addressZipcode;
    private String addressCity;
    private String addressRegion;
    private String addressCountry;
    private String group1;
    private String group2;
    private String role;
    private List<ErpBussinesUnit> bu;
    private List<ErpDistributor> dist;

    @JsonProperty("taxId")
    @Size(max = 15)
    public String getTaxId() {
        return taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    @JsonProperty("name")
    @Size(max = 40)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("addressStreet")
    @Size(max = 100)
    public String getAddressStreet() {
        return addressStreet;
    }

    public void setAddressStreet(String addressStreet) {
        this.addressStreet = addressStreet;
    }

    @JsonProperty("addressZipcode")
    @Size(max = 10)
    public String getAddressZipcode() {
        return addressZipcode;
    }

    public void setAddressZipcode(String addressZipcode) {
        this.addressZipcode = addressZipcode;
    }

    @JsonProperty("addressCity")
    @Size(max = 40)
    public String getAddressCity() {
        return addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    @JsonProperty("addressRegion")
    @Size(max = 20)
    public String getAddressRegion() {
        return addressRegion;
    }

    public void setAddressRegion(String addressRegion) {
        this.addressRegion = addressRegion;
    }

    @JsonProperty("addressCountry")
    @Size(max = 3)
    public String getAddressCountry() {
        return addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    @JsonProperty("group1")
    @Size(max = 20)
    public String getGroup1() {
        return group1;
    }

    public void setGroup1(String group1) {
        this.group1 = group1;
    }

    @JsonProperty("group2")
    @Size(max = 20)
    public String getGroup2() {
        return group2;
    }

    public void setGroup2(String group2) {
        this.group2 = group2;
    }

    @JsonProperty("role")
    @Size(max = 1)
    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty("bu")
    public List<ErpBussinesUnit> getBu() {
        return bu;
    }

    public void setBu(List<ErpBussinesUnit> bu) {
        this.bu = bu;
    }

    @JsonProperty("dist")
    public List<ErpDistributor> getDist() {
        return dist;
    }

    public void setDist(List<ErpDistributor> dist) {
        this.dist = dist;
    }

    @Override
    public String toString() {
        return "ErpCompany ["
                + ((taxId != null) ? "taxId=" + taxId + ", " : "")
                + ((name != null) ? "name=" + name + ", " : "")
                + ((addressStreet != null) ? "addressStreet=" + addressStreet + ", " : "")
                + ((addressZipcode != null) ? "addressZipcode=" + addressZipcode + ", " : "")
                + ((addressCity != null) ? "addressCity=" + addressCity + ", " : "")
                + ((addressRegion != null) ? "addressRegion=" + addressRegion + ", " : "")
                + ((addressCountry != null) ? "addressCountry=" + addressCountry + ", " : "")
                + ((group1 != null) ? "groupZone=" + group1 + ", " : "")
                + ((group2 != null) ? "groupSalesArea=" + group2 + ", " : "")
                + ((role != null) ? "role=" + role + ", " : "")
                + ((bu != null) ? "bu=" + Arrays.toString(bu.toArray()) + ", " : "")
                + ((dist != null) ? "dist=" + Arrays.toString(dist.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpCompany that = (ErpCompany) o;
        return Objects.equals(taxId, that.taxId) && Objects.equals(name, that.name) && Objects.equals(addressStreet, that.addressStreet) && Objects.equals(addressZipcode, that.addressZipcode) && Objects.equals(addressCity, that.addressCity) && Objects.equals(addressRegion, that.addressRegion) && Objects.equals(addressCountry, that.addressCountry) && Objects.equals(group1, that.group1) && Objects.equals(group2, that.group2) && Objects.equals(role, that.role) && Objects.equals(bu, that.bu) && Objects.equals(dist, that.dist);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taxId, name, addressStreet, addressZipcode, addressCity, addressRegion, addressCountry, group1, group2, role, bu, dist);
    }
}
