package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocumentCommentSet implements Serializable {

    public enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),

        INCREMENTAL("INCREMENTAL");

        private String value;

        PublicationModeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private String trackingNumber;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate;
    private PublicationModeEnum publicationMode;
    private String biller;
    private String payerCuit;
    private String payerCode;
    private String ownerType;
    private String ownerDocRef;
    private String legalDocRef;
    private Double totalAmount;
    private Double exchangeRate;
    private List<ErpDocumentComment> detail;

    @JsonProperty("trackingNumber")
    @NotNull
    @Size(max = 20)
    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @JsonProperty("processDate")
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @JsonProperty("publicationMode")
    @Size(max = 20)
    public PublicationModeEnum getPublicationMode() {
        return publicationMode;
    }

    public void setPublicationMode(PublicationModeEnum publicationMode) {
        this.publicationMode = publicationMode;
    }

    @JsonProperty("biller")
    @NotNull
    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    @JsonProperty("payerCuit")
    @NotNull
    @Size(max = 11)
    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    @JsonProperty("payerCode")
    @NotNull
    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    @JsonProperty("ownerType")
    @NotNull
    @Size(max = 10)
    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    @JsonProperty("ownerDocRef")
    @NotNull
    @Size(max = 255)
    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    @JsonProperty("legalDocRef")
    @NotNull
    @Size(max = 255)
    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    @JsonProperty("totalAmount")
    public Double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty("exchangeRate")
    @Size(max = 20)
    public Double getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(Double exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    @JsonProperty("detail")
    public List<ErpDocumentComment> getDetail() {
        return detail;
    }

    public void setDetail(List<ErpDocumentComment> detail) {
        this.detail = detail;
    }

    @Override
    public String toString() {
        return "ErpDocumentCommentSet ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((publicationMode != null) ? "publicationMode=" + publicationMode + ", " : "")
                + ((biller != null) ? "biller=" + biller + ", " : "")
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((ownerType != null) ? "ownerType=" + ownerType + ", " : "")
                + ((ownerDocRef != null) ? "ownerDocRef=" + ownerDocRef + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "")
                + ((exchangeRate != null) ? "exchangeRate=" + exchangeRate + ", " : "")
                + ((detail != null) ? "detail=" + Arrays.toString(detail.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpDocumentCommentSet that = (ErpDocumentCommentSet) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(processDate, that.processDate) && publicationMode == that.publicationMode && Objects.equals(biller, that.biller) && Objects.equals(payerCuit, that.payerCuit) && Objects.equals(payerCode, that.payerCode) && Objects.equals(ownerType, that.ownerType) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(exchangeRate, that.exchangeRate) && Objects.equals(detail, that.detail);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, processDate, publicationMode, biller, payerCuit, payerCode, ownerType, ownerDocRef, legalDocRef, totalAmount, exchangeRate, detail);
    }
}