package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocumentComment implements Serializable {

    private String ownerType;
    private String relatedOwnerDocRef;
    private String relatedLegalDocRef;
    private BigDecimal dueAmount;
    private BigDecimal dueAmountUSD;
    private BigDecimal dueAmountRate;
    private BigDecimal differenceAmount;

    @JsonProperty("ownerType")
    @Size(max = 10)
    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    @JsonProperty("relatedOwnerDocRef")
    @Size(max = 30)
    public String getRelatedOwnerDocRef() {
        return relatedOwnerDocRef;
    }

    public void setRelatedOwnerDocRef(String relatedOwnerDocRef) {
        this.relatedOwnerDocRef = relatedOwnerDocRef;
    }

    @JsonProperty("relatedLegalDocRef")
    @Size(max = 30)
    public String getRelatedLegalDocRef() {
        return relatedLegalDocRef;
    }

    public void setRelatedLegalDocRef(String relatedLegalDocRef) {
        this.relatedLegalDocRef = relatedLegalDocRef;
    }

    @JsonProperty("dueAmount")
    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    @JsonProperty("dueAmountUSD")
    public BigDecimal getDueAmountUSD() {
        return dueAmountUSD;
    }

    public void setDueAmountUSD(BigDecimal dueAmountUSD) {
        this.dueAmountUSD = dueAmountUSD;
    }

    @JsonProperty("dueAmountRate")
    @NotNull
    public BigDecimal getDueAmountRate() {
        return dueAmountRate;
    }

    public void setDueAmountRate(BigDecimal dueAmountRate) {
        this.dueAmountRate = dueAmountRate;
    }

    @JsonProperty("differenceAmount")
    @NotNull
    public BigDecimal getDifferenceAmount() {
        return differenceAmount;
    }

    public void setDifferenceAmount(BigDecimal differenceAmount) {
        this.differenceAmount = differenceAmount;
    }

    @Override
    public String toString() {
        return "ErpDocumentComment ["
                + ((ownerType != null) ? "ownerType=" + ownerType + ", " : "")
                + ((relatedOwnerDocRef != null) ? "relatedOwnerDocRef=" + relatedOwnerDocRef + ", " : "")
                + ((relatedLegalDocRef != null) ? "relatedLegalDocRef=" + relatedLegalDocRef + ", " : "")
                + ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "")
                + ((dueAmountUSD != null) ? "dueAmountUSD=" + dueAmountUSD + ", " : "")
                + ((dueAmountRate != null) ? "dueAmountRate=" + dueAmountRate + ", " : "")
                + ((differenceAmount != null) ? "differenceAmount=" + differenceAmount : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpDocumentComment comment = (ErpDocumentComment) o;
        return Objects.equals(ownerType, comment.ownerType) && Objects.equals(relatedOwnerDocRef, comment.relatedOwnerDocRef) && Objects.equals(relatedLegalDocRef, comment.relatedLegalDocRef) && Objects.equals(dueAmount, comment.dueAmount) && Objects.equals(dueAmountUSD, comment.dueAmountUSD) && Objects.equals(dueAmountRate, comment.dueAmountRate) && Objects.equals(differenceAmount, comment.differenceAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ownerType, relatedOwnerDocRef, relatedLegalDocRef, dueAmount, dueAmountUSD, dueAmountRate, differenceAmount);
    }
}