package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpCompany implements Serializable {

    private String taxId;
    private String name;
    private String addressStreet;
    private String addressZipcode;
    private String addressCity;
    private String addressRegion;
    private String addressCountry;
    private String groupZone;
    private String groupSalesArea;
    private String role;
    private List<ErpBu> bu;
    private List<ErpDist> dist;

    @JsonProperty("taxId")
    @Size(max = 15)
    public String getTaxId() {
        return taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    @JsonProperty("name")
    @Size(max = 40)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("address_street")
    @Size(max = 100)
    public String getAddressStreet() {
        return addressStreet;
    }

    public void setAddressStreet(String addressStreet) {
        this.addressStreet = addressStreet;
    }

    @JsonProperty("address_zipcode")
    @Size(max = 10)
    public String getAddressZipcode() {
        return addressZipcode;
    }

    public void setAddressZipcode(String addressZipcode) {
        this.addressZipcode = addressZipcode;
    }

    @JsonProperty("address_city")
    @Size(max = 40)
    public String getAddressCity() {
        return addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    @JsonProperty("address_region")
    @Size(max = 20)
    public String getAddressRegion() {
        return addressRegion;
    }

    public void setAddressRegion(String addressRegion) {
        this.addressRegion = addressRegion;
    }

    @JsonProperty("address_country")
    @Size(max = 3)
    public String getAddressCountry() {
        return addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    @JsonProperty("group_zone")
    @Size(max = 20)
    public String getGroupZone() {
        return groupZone;
    }

    public void setGroupZone(String groupZone) {
        this.groupZone = groupZone;
    }

    @JsonProperty("group_salesArea")
    @Size(max = 10)
    public String getGroupSalesArea() {
        return groupSalesArea;
    }

    public void setGroupSalesArea(String groupSalesArea) {
        this.groupSalesArea = groupSalesArea;
    }

    @JsonProperty("role")
    @Size(max = 1)
    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty("bu")
    public List<ErpBu> getBu() {
        return bu;
    }

    public void setBu(List<ErpBu> bu) {
        this.bu = bu;
    }

    @JsonProperty("dist")
    public List<ErpDist> getDist() {
        return dist;
    }

    public void setDist(List<ErpDist> dist) {
        this.dist = dist;
    }

    @Override
    public String toString() {
        return "ErpCompany ["
                + ((taxId != null) ? "taxId=" + taxId + ", " : "")
                + ((name != null) ? "name=" + name + ", " : "")
                + ((addressStreet != null) ? "addressStreet=" + addressStreet + ", " : "")
                + ((addressZipcode != null) ? "addressZipcode=" + addressZipcode + ", " : "")
                + ((addressCity != null) ? "addressCity=" + addressCity + ", " : "")
                + ((addressRegion != null) ? "addressRegion=" + addressRegion + ", " : "")
                + ((addressCountry != null) ? "addressCountry=" + addressCountry + ", " : "")
                + ((groupZone != null) ? "groupZone=" + groupZone + ", " : "")
                + ((groupSalesArea != null) ? "groupSalesArea=" + groupSalesArea + ", " : "")
                + ((role != null) ? "role=" + role + ", " : "")
                + ((bu != null) ? "bu=" + Arrays.toString(bu.toArray()) + ", " : "")
                + ((dist != null) ? "dist=" + Arrays.toString(dist.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpCompany that = (ErpCompany) o;
        return Objects.equals(taxId, that.taxId) && Objects.equals(name, that.name) && Objects.equals(addressStreet, that.addressStreet) && Objects.equals(addressZipcode, that.addressZipcode) && Objects.equals(addressCity, that.addressCity) && Objects.equals(addressRegion, that.addressRegion) && Objects.equals(addressCountry, that.addressCountry) && Objects.equals(groupZone, that.groupZone) && Objects.equals(groupSalesArea, that.groupSalesArea) && Objects.equals(role, that.role) && Objects.equals(bu, that.bu) && Objects.equals(dist, that.dist);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taxId, name, addressStreet, addressZipcode, addressCity, addressRegion, addressCountry, groupZone, groupSalesArea, role, bu, dist);
    }
}
