package ar.com.sdd.ebfapi.client.model.contrato.inba;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.math.BigDecimal;
import java.util.Date;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Pagos {

    private String nroComprobante;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaPago;
    private String moneda;
    private BigDecimal importePagado;
    private Long comprobantePago;
    private Long comprobantePagoBanco;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaVencimiento;
    private BigDecimal importeVencimiento;
    private Long identificadorDeuda;

    public String getNroComprobante() {
        return nroComprobante;
    }

    public void setNroComprobante(String nroComprobante) {
        this.nroComprobante = nroComprobante;
    }

    public Date getFechaPago() {
        return fechaPago;
    }

    public void setFechaPago(Date fechaPago) {
        this.fechaPago = fechaPago;
    }

    public String getMoneda() {
        return moneda;
    }

    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImportePagado() {
        return importePagado;
    }

    public void setImportePagado(BigDecimal importePagado) {
        this.importePagado = importePagado;
    }

    public Long getComprobantePago() {
        return comprobantePago;
    }

    public void setComprobantePago(Long comprobantePago) {
        this.comprobantePago = comprobantePago;
    }

    public Long getComprobantePagoBanco() {
        return comprobantePagoBanco;
    }

    public void setComprobantePagoBanco(Long comprobantePagoBanco) {
        this.comprobantePagoBanco = comprobantePagoBanco;
    }

    public Date getFechaVencimiento() {
        return fechaVencimiento;
    }

    public void setFechaVencimiento(Date fechaVencimiento) {
        this.fechaVencimiento = fechaVencimiento;
    }

    public BigDecimal getImporteVencimiento() {
        return importeVencimiento;
    }

    public void setImporteVencimiento(BigDecimal importeVencimiento) {
        this.importeVencimiento = importeVencimiento;
    }

    public Long getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(Long identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    @Override
    public String toString() {
        return "Pagos ["
                + ((nroComprobante != null) ? "nroComprobante=" + nroComprobante + ", " : "")
                + ((fechaPago != null) ? "fechaPago=" + fechaPago + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((importePagado != null) ? "importePagado=" + importePagado + ", " : "")
                + ((comprobantePago != null) ? "comprobantePago=" + comprobantePago + ", " : "")
                + ((comprobantePagoBanco != null) ? "comprobantePagoBanco=" + comprobantePagoBanco + ", " : "")
                + ((fechaVencimiento != null) ? "fechaVencimiento=" + fechaVencimiento + ", " : "")
                + ((importeVencimiento != null) ? "importeVencimiento=" + importeVencimiento + ", " : "")
                + ((identificadorDeuda != null) ? "identificadorDeuda=" + identificadorDeuda : "")
                + "]";
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Pagos pagos = (Pagos) o;

        if (nroComprobante != null ? !nroComprobante.equals(pagos.nroComprobante) : pagos.nroComprobante != null) return false;
        if (fechaPago != null ? !fechaPago.equals(pagos.fechaPago) : pagos.fechaPago != null) return false;
        if (moneda != null ? !moneda.equals(pagos.moneda) : pagos.moneda != null) return false;
        if (importePagado != null ? !importePagado.equals(pagos.importePagado) : pagos.importePagado != null) return false;
        if (comprobantePago != null ? !comprobantePago.equals(pagos.comprobantePago) : pagos.comprobantePago != null) return false;
        if (comprobantePagoBanco != null ? !comprobantePagoBanco.equals(pagos.comprobantePagoBanco) : pagos.comprobantePagoBanco != null) return false;
        if (fechaVencimiento != null ? !fechaVencimiento.equals(pagos.fechaVencimiento) : pagos.fechaVencimiento != null) return false;
        if (importeVencimiento != null ? !importeVencimiento.equals(pagos.importeVencimiento) : pagos.importeVencimiento != null) return false;
        return identificadorDeuda != null ? identificadorDeuda.equals(pagos.identificadorDeuda) : pagos.identificadorDeuda == null;
    }

    @Override
    public int hashCode() {
        int result = nroComprobante != null ? nroComprobante.hashCode() : 0;
        result = 31 * result + (fechaPago != null ? fechaPago.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (importePagado != null ? importePagado.hashCode() : 0);
        result = 31 * result + (comprobantePago != null ? comprobantePago.hashCode() : 0);
        result = 31 * result + (comprobantePagoBanco != null ? comprobantePagoBanco.hashCode() : 0);
        result = 31 * result + (fechaVencimiento != null ? fechaVencimiento.hashCode() : 0);
        result = 31 * result + (importeVencimiento != null ? importeVencimiento.hashCode() : 0);
        result = 31 * result + (identificadorDeuda != null ? identificadorDeuda.hashCode() : 0);
        return result;
    }
}
