package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpPayment implements Serializable {

    private String type;
    private String paymentTerms;
    private String legalDocRef;
    private String ownerDocRef;
    private List<ErpDocument> erpDocuments;
    private List<ErpDocument> instruments;
    private List<ErpDocument> deductions;
    private List<ErpDocument> retentions;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creationDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'", timezone = "GMT+00:00")
    private Date creationTimestampUtc;
    private BigDecimal exchangeRate;
    private String status;
    private String comments;
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public List<ErpDocument> getErpDocuments() {
        return erpDocuments;
    }

    public void setErpDocuments(List<ErpDocument> erpDocuments) {
        this.erpDocuments = erpDocuments;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getCreationTimestampUtc() {
        return creationTimestampUtc;
    }

    public void setCreationTimestampUtc(Date creationTimestampUtc) {
        this.creationTimestampUtc = creationTimestampUtc;
    }

    public String getPaymentTerms() {
        return paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public List<ErpDocument> getInstruments() {
        return instruments;
    }

    public void setInstruments(List<ErpDocument> instruments) {
        this.instruments = instruments;
    }

    public List<ErpDocument> getDeductions() {
        return deductions;
    }

    public void setDeductions(List<ErpDocument> deductions) {
        this.deductions = deductions;
    }

    public List<ErpDocument> getRetentions() {
        return retentions;
    }

    public void setRetentions(List<ErpDocument> retentions) {
        this.retentions = retentions;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public String toString() {
        return "ErpPayment [" +
                ((type != null) ? "type='" + type + "', " : "") +
                ((paymentTerms != null) ? "paymentTerms='" + paymentTerms + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((erpDocuments != null) ? "erpDocuments=" + Arrays.toString(erpDocuments.toArray()) + ", " : "") +
                ((instruments != null) ? "instruments=" + Arrays.toString(instruments.toArray()) + ", " : "") +
                ((deductions != null) ? "deductions=" + Arrays.toString(deductions.toArray()) + ", " : "") +
                ((retentions != null) ? "retentions=" + Arrays.toString(retentions.toArray()) + ", " : "") +
                ((creationDate != null) ? "creationDate=" + creationDate + ", " : "") +
                ((creationTimestampUtc != null) ? "creationTimestampUtc=" + creationTimestampUtc + ", " : "") +
                ((exchangeRate != null) ? "exchangeRate=" + exchangeRate + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpPayment that = (ErpPayment) o;
        return Objects.equals(type, that.type) && Objects.equals(paymentTerms, that.paymentTerms) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(erpDocuments, that.erpDocuments) && Objects.equals(instruments, that.instruments) && Objects.equals(deductions, that.deductions) && Objects.equals(retentions, that.retentions) && Objects.equals(creationDate, that.creationDate) && Objects.equals(creationTimestampUtc, that.creationTimestampUtc) && Objects.equals(exchangeRate, that.exchangeRate) && Objects.equals(status, that.status) && Objects.equals(comments, that.comments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, paymentTerms, legalDocRef, ownerDocRef, erpDocuments, instruments, deductions, retentions, creationDate, creationTimestampUtc, exchangeRate, status, comments);
    }
}
