package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActionLink implements Serializable {

    private String actionUrl;
    private String trackingNumber;
    private String orderNumber;
    private String expiresIn;

    public ActionLink() {
    }

    public ActionLink(String actionUrl, String trackingNumber, String orderNumber, String expiresIn) {
        this.actionUrl = actionUrl;
        this.trackingNumber = trackingNumber;
        this.orderNumber = orderNumber;
        this.expiresIn = expiresIn;
    }

    public String getActionUrl() {
        return actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "ActionLink [" +
                ((actionUrl != null) ? "actionUrl='" + actionUrl + "', " : "") +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((expiresIn != null) ? "expiresIn='" + expiresIn + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ActionLink that = (ActionLink) o;
        return Objects.equals(actionUrl, that.actionUrl) && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(orderNumber, that.orderNumber) && Objects.equals(expiresIn, that.expiresIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(actionUrl, trackingNumber, orderNumber, expiresIn);
    }
}