package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SsoCheckEbfApi implements Serializable {

    private Boolean success;
    private String message;

    //Campos tomados de OperatorAssertion
    private String companyName;
    private String operatorDescription;
    private String operatorEmail;
    private String operatorName;


    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getOperatorDescription() {
        return operatorDescription;
    }

    public void setOperatorDescription(String operatorDescription) {
        this.operatorDescription = operatorDescription;
    }

    public String getOperatorEmail() {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.operatorEmail = operatorEmail;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    @Override
    public String toString() {
        return "SsoCheckEbfApi ["
                + ((success != null) ? "success=" + success + ", " : "")
                + ((message != null) ? "message=" + message + ", " : "")
                + ((companyName != null) ? "companyName=" + companyName + ", " : "")
                + ((operatorDescription != null) ? "operatorDescription=" + operatorDescription + ", " : "")
                + ((operatorEmail != null) ? "operatorEmail=" + operatorEmail + ", " : "")
                + ((operatorName != null) ? "operatorName=" + operatorName : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SsoCheckEbfApi that = (SsoCheckEbfApi) o;

        if (success != null ? !success.equals(that.success) : that.success != null) return false;
        if (message != null ? !message.equals(that.message) : that.message != null) return false;
        if (companyName != null ? !companyName.equals(that.companyName) : that.companyName != null) return false;
        if (operatorDescription != null ? !operatorDescription.equals(that.operatorDescription) : that.operatorDescription != null) return false;
        if (operatorEmail != null ? !operatorEmail.equals(that.operatorEmail) : that.operatorEmail != null) return false;
        return operatorName != null ? operatorName.equals(that.operatorName) : that.operatorName == null;
    }

    @Override
    public int hashCode() {
        int result = success != null ? success.hashCode() : 0;
        result = 31 * result + (message != null ? message.hashCode() : 0);
        result = 31 * result + (companyName != null ? companyName.hashCode() : 0);
        result = 31 * result + (operatorDescription != null ? operatorDescription.hashCode() : 0);
        result = 31 * result + (operatorEmail != null ? operatorEmail.hashCode() : 0);
        result = 31 * result + (operatorName != null ? operatorName.hashCode() : 0);
        return result;
    }
}
