package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.*;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpCompanySet implements Serializable {

    public enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),

        INCREMENTAL("INCREMENTAL");

        private String value;

        PublicationModeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    private String trackingNumber;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate;
    private PublicationModeEnum publicationMode;
    private List<ErpCompany> companies;

    @Size(max = 20)
    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @JsonProperty("processDate")
    @NotNull
    @Size(max = 10)
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @JsonProperty("publicationMode")
    @NotNull
    @Size(max = 20)
    public PublicationModeEnum getPublicationMode() {
        return publicationMode;
    }

    public void setPublicationMode(PublicationModeEnum publicationMode) {
        this.publicationMode = publicationMode;
    }

    @JsonProperty("companies")
    public List<ErpCompany> getCompanies() {
        return companies;
    }

    public void setCompanies(List<ErpCompany> companies) {
        this.companies = companies;
    }

    @Override
    public String toString() {
        return "ErpCompanySet ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((publicationMode != null) ? "publicationMode=" + publicationMode + ", " : "")
                + ((companies != null) ? "companies=" + Arrays.toString(companies.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpCompanySet that = (ErpCompanySet) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(processDate, that.processDate) && publicationMode == that.publicationMode && Objects.equals(companies, that.companies);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, processDate, publicationMode, companies);
    }
}