/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.ebfapi.client.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.OAuth2Credential;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.ebfapi.client.core.CuentaSimpleEbfApiConnectorContext;
import ar.com.sdd.ebfapi.client.model.ActionLink;
import ar.com.sdd.ebfapi.client.model.RedirectionActionLinkData;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CuentaSimpleEbfApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(CuentaSimpleEbfApiConnector.class);
    private final RestConnector restConnector;
    private final String clientId;
    private final String clientSecret;
    private final String applicationId;
    private final String ownerName;
    private boolean doingLogin;
    private boolean forceRefresh;

    public CuentaSimpleEbfApiConnector(CuentaSimpleEbfApiConnectorContext context) {
        this.clientId = context.getClientId();
        this.clientSecret = context.getClientSecret();
        this.applicationId = context.getApplicationId();
        this.ownerName = context.getOwnerName();
        log.trace("Creando CuentaSimpleEbfApiConnector con {}", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public ActionLink postGenerateRedirectionActionLink(RedirectionActionLinkData redirectionActionLinkData) throws RestConnectorException {
        String path = "/actionlink/aid/" + this.applicationId + "/owner/" + this.ownerName + "/redirectLink";
        log.debug("[postGenerateRedirectionActionLink] Por solicitar un link de redireccionamiento con path [{}] y {}", (Object)path, (Object)redirectionActionLinkData);
        return (ActionLink)this.restConnector.genericPost((Object)redirectionActionLinkData, ActionLink.class, path);
    }

    private String getAccessToken() throws RestConnectorException {
        String cacheKey;
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(CuentaSimpleEbfApiConnector.class.getName());
        String accessToken = (String)cache.get(cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"}));
        if (accessToken == null || this.forceRefresh) {
            OAuth2Credential oAuth2Credential = new OAuth2Credential();
            oAuth2Credential.setClientId(this.clientId);
            oAuth2Credential.setClientSecret(this.clientSecret);
            oAuth2Credential.setGrantType("client_credentials");
            this.doingLogin = true;
            String path = "/auth/aid/" + this.applicationId + "/owner/" + this.ownerName + "/token.oauth2";
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)this.restConnector.genericPost((Object)oAuth2Credential, TokenOAuth2.class, path);
            this.doingLogin = false;
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}] segs. Lo agrego al a cache", (Object)tokenOAuth2Response, (Object)tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, (Object)accessToken, tokenOAuth2Response.getExpiresIn());
            if (this.forceRefresh) {
                this.forceRefresh = false;
            }
        }
        return accessToken;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null && !this.doingLogin) {
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        this.forceRefresh = true;
        return true;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

