package ar.com.sdd.ebfapi.client.io.contrato.inba;

import ar.com.sdd.ebfapi.client.model.contrato.inba.Deuda;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DeudaRequest {

    private Long identificadorDeuda;
    private Deuda deuda;

    public Long getIdentificadorDeuda() {
        return identificadorDeuda;
    }

    public void setIdentificadorDeuda(Long identificadorDeuda) {
        this.identificadorDeuda = identificadorDeuda;
    }

    public Deuda getDeuda() {
        return deuda;
    }

    public void setDeuda(Deuda deuda) {
        this.deuda = deuda;
    }

    @Override
    public String toString() {
        return "DeudaRequest ["
                + ((identificadorDeuda != null) ? "identificadorDeuda=" + identificadorDeuda + ", " : "")
                + ((deuda != null) ? "deuda=" + deuda : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DeudaRequest that = (DeudaRequest) o;

        if (identificadorDeuda != null ? !identificadorDeuda.equals(that.identificadorDeuda) : that.identificadorDeuda != null) return false;
        return deuda != null ? deuda.equals(that.deuda) : that.deuda == null;
    }

    @Override
    public int hashCode() {
        int result = identificadorDeuda != null ? identificadorDeuda.hashCode() : 0;
        result = 31 * result + (deuda != null ? deuda.hashCode() : 0);
        return result;
    }
}
