package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RedirectionActionLinkData {

    private OperatorEbfApi operatorEbfApi;
    private Long instanceId;
    private String url;

    public OperatorEbfApi getOperatorEbfApi() {
        return operatorEbfApi;
    }

    public void setOperatorEbfApi(OperatorEbfApi operatorEbfApi) {
        this.operatorEbfApi = operatorEbfApi;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        return "RedirectionActionLinkData [" +
                ((operatorEbfApi != null) ? "operatorEbfApi=" + operatorEbfApi + ", " : "") +
                ((instanceId != null) ? "instanceId=" + instanceId + ", " : "") +
                ((url != null) ? "url='" + url + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RedirectionActionLinkData that = (RedirectionActionLinkData) o;
        return Objects.equals(operatorEbfApi, that.operatorEbfApi) && Objects.equals(instanceId, that.instanceId) && Objects.equals(url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operatorEbfApi, instanceId, url);
    }
}