package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.*;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocumentAttach implements Serializable {

    public enum PublicationModeEnum {
        FULLREFRESH("FULLREFRESH"),

        INCREMENTAL("INCREMENTAL");

        private String value;

        PublicationModeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    public enum AttachmentTypeEnum {
        PDF("PDF"),
        ZIP("ZIP");

        private String value;

        AttachmentTypeEnum(String value) {
            this.value = value;
        }

        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate;
    private PublicationModeEnum publicationMode;
    private String trackingNumber;
    private String biller;
    private String payerCuit;
    private String payerCode;
    private String ownerType;
    private String ownerDocRef;
    private String legalDocRef;
    private String attachmentName;
    private AttachmentTypeEnum attachmentType;
    private String attachmentString;

    @JsonProperty("processDate")
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @JsonProperty("publicationMode")
    @Size(max = 20)
    public PublicationModeEnum getPublicationMode() {
        return publicationMode;
    }

    public void setPublicationMode(PublicationModeEnum publicationMode) {
        this.publicationMode = publicationMode;
    }

    @JsonProperty("trackingNumber")
    @NotNull
    @Size(max = 20)
    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @JsonProperty("biller")
    @NotNull
    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    @JsonProperty("payerCuit")
    @NotNull
    @Size(max = 11)
    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    @JsonProperty("payerCode")
    @NotNull
    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    @JsonProperty("ownerType")
    @NotNull
    @Size(max = 10)
    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    @JsonProperty("ownerDocRef")
    @NotNull
    @Size(max = 255)
    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    @JsonProperty("legalDocRef")
    @NotNull
    @Size(max = 255)
    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    @JsonProperty("attachmentName")
    @Size(max = 255)
    public String getAttachmentName() {
        return attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    @JsonProperty("attachmentType")
    @NotNull
    @Size(max = 255)
    public AttachmentTypeEnum getAttachmentType() {
        return attachmentType;
    }

    public void setAttachmentType(AttachmentTypeEnum attachmentType) {
        this.attachmentType = attachmentType;
    }

    @JsonProperty("attachmentString")
    @NotNull
    @Size(max = 999999999)
    public String getAttachmentString() {
        return attachmentString;
    }

    public void setAttachmentString(String attachmentString) {
        this.attachmentString = attachmentString;
    }

    @Override
    public String toString() {
        return "ErpDocumentAttach ["
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((publicationMode != null) ? "publicationMode=" + publicationMode + ", " : "")
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((biller != null) ? "owner=" + biller + ", " : "")
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((ownerType != null) ? "ownerType=" + ownerType + ", " : "")
                + ((ownerDocRef != null) ? "ownerDocRef=" + ownerDocRef + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((attachmentName != null) ? "attachmentName=" + attachmentName + ", " : "")
                + ((attachmentType != null) ? "attachmentType=" + attachmentType + ", " : "")
                + ((attachmentString != null) ? "attachmentString=" + attachmentString : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpDocumentAttach that = (ErpDocumentAttach) o;
        return Objects.equals(processDate, that.processDate) && publicationMode == that.publicationMode && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(biller, that.biller) && Objects.equals(payerCuit, that.payerCuit) && Objects.equals(payerCode, that.payerCode) && Objects.equals(ownerType, that.ownerType) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(attachmentName, that.attachmentName) && attachmentType == that.attachmentType && Objects.equals(attachmentString, that.attachmentString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(processDate, publicationMode, trackingNumber, biller, payerCuit, payerCode, ownerType, ownerDocRef, legalDocRef, attachmentName, attachmentType, attachmentString);
    }
}