package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CompanyAccountEbfApi implements Serializable {

    private String uid;
    private String description;
    private String externalReference;
    private CompanyEbfApi accountOwner;
    private BankEbfApi bank;
    private String csExternalReference;
    private String branchCode;
    private String ownerFiscalDocRef;
    private String billerAccountRef;
    private boolean isDefault;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public CompanyEbfApi getAccountOwner() {
        return accountOwner;
    }

    public void setAccountOwner(CompanyEbfApi accountOwner) {
        this.accountOwner = accountOwner;
    }

    public BankEbfApi getBank() {
        return bank;
    }

    public void setBank(BankEbfApi bank) {
        this.bank = bank;
    }

    public String getCsExternalReference() {
        return csExternalReference;
    }

    public void setCsExternalReference(String csExternalReference) {
        this.csExternalReference = csExternalReference;
    }

    public String getBranchCode() {
        return branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public String getOwnerFiscalDocRef() {
        return ownerFiscalDocRef;
    }

    public void setOwnerFiscalDocRef(String ownerFiscalDocRef) {
        this.ownerFiscalDocRef = ownerFiscalDocRef;
    }

    public String getBillerAccountRef() {
        return billerAccountRef;
    }

    public void setBillerAccountRef(String billerAccountRef) {
        this.billerAccountRef = billerAccountRef;
    }

    public boolean getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public String toString() {
        return "CompanyAccountEbfApi [" +
                ((uid != null) ? "uid='" + uid + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((externalReference != null) ? "externalReference='" + externalReference + "', " : "") +
                ((accountOwner != null) ? "accountOwner=" + accountOwner + ", " : "") +
                ((bank != null) ? "bank=" + bank + ", " : "") +
                ((csExternalReference != null) ? "csExternalReference='" + csExternalReference + "', " : "") +
                ((branchCode != null) ? "branchCode='" + branchCode + "', " : "") +
                ((ownerFiscalDocRef != null) ? "ownerFiscalDocRef='" + ownerFiscalDocRef + "', " : "") +
                ((billerAccountRef != null) ? "billerAccountRef='" + billerAccountRef + "', " : "") +
                "isDefault=" + isDefault +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CompanyAccountEbfApi that = (CompanyAccountEbfApi) o;
        return isDefault == that.isDefault && Objects.equals(uid, that.uid) && Objects.equals(description, that.description) && Objects.equals(externalReference, that.externalReference) && Objects.equals(accountOwner, that.accountOwner) && Objects.equals(bank, that.bank) && Objects.equals(csExternalReference, that.csExternalReference) && Objects.equals(branchCode, that.branchCode) && Objects.equals(ownerFiscalDocRef, that.ownerFiscalDocRef) && Objects.equals(billerAccountRef, that.billerAccountRef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, description, externalReference, accountOwner, bank, csExternalReference, branchCode, ownerFiscalDocRef, billerAccountRef, isDefault);
    }
}
