package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class NotificationEbfApi implements Serializable {

    private String id;

    /**
     * Url de la plataforma que envia la notificacion.
     * Se llena con "serverURL" (Application.getServerRootUrl())
     */
    private String source;

    /**
     * Evento que ocurrio que hizo que se lance la notificacion
     */
    private String event;

    /**
     * Entidad a la que fue lanzado el evento
     * Ejemplos: BCDBN, DBNV
     */
    private String entityType;

    /**
     * Nro de Referencia de la entidad. Para los Debin enviar el legalDocRef
     */
    private String entityReference;

    /**
     * Por si queremos dejar algun comentario extra en la notificacion
     */
    private String comments;

    public NotificationEbfApi() {

    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEntityType() {
        return entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getEntityReference() {
        return entityReference;
    }

    public void setEntityReference(String entityReference) {
        this.entityReference = entityReference;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public String toString() {
        return "NotificationEbfApi [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((source != null) ? "source='" + source + "', " : "") +
                ((event != null) ? "event='" + event + "', " : "") +
                ((entityType != null) ? "entityType='" + entityType + "', " : "") +
                ((entityReference != null) ? "entityReference='" + entityReference + "', " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NotificationEbfApi that = (NotificationEbfApi) o;
        return Objects.equals(id, that.id) && Objects.equals(source, that.source) && Objects.equals(event, that.event) && Objects.equals(entityType, that.entityType) && Objects.equals(entityReference, that.entityReference) && Objects.equals(comments, that.comments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, source, event, entityType, entityReference, comments);
    }
}