package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SessionEbfApi implements Serializable {

    private OperatorEbfApi operatorEbfApi;
    private RightSetEbfApi rightSetEbfApi;
    private Date processDate;
    private List<DocumentReasonTypeEbfApi> allOwnersPaymentReasonTypes; //botones habilitados para pagar (para todos los owners sin discriminar)
    private CompanyEbfApi selectedOwner;    //si hay un solo owner, se preelije
    private CompanyEbfApi selectedCollector; //si hay una sola collector company, se preelije
    private List<CompanyEbfApi> owners;    //Owners tomados de la ebfSession que tienen relacion con el usuario logeado
    private List<CompanyEbfApi> collectors; //Las collector company de la instancia
    private String relationType; //ADM, BIL, PAY

    public OperatorEbfApi getOperatorEbfApi() {
        return operatorEbfApi;
    }

    public void setOperatorEbfApi(OperatorEbfApi operatorEbfApi) {
        this.operatorEbfApi = operatorEbfApi;
    }

    public RightSetEbfApi getRightSetEbfApi() {
        return rightSetEbfApi;
    }

    public void setRightSetEbfApi(RightSetEbfApi rightSetEbfApi) {
        this.rightSetEbfApi = rightSetEbfApi;
    }

    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    public List<DocumentReasonTypeEbfApi> getAllOwnersPaymentReasonTypes() {
        return allOwnersPaymentReasonTypes;
    }

    public void setAllOwnersPaymentReasonTypes(List<DocumentReasonTypeEbfApi> allOwnersPaymentReasonTypes) {
        this.allOwnersPaymentReasonTypes = allOwnersPaymentReasonTypes;
    }

    public CompanyEbfApi getSelectedOwner() {
        return selectedOwner;
    }

    public void setSelectedOwner(CompanyEbfApi selectedOwner) {
        this.selectedOwner = selectedOwner;
    }

    public CompanyEbfApi getSelectedCollector() {
        return selectedCollector;
    }

    public void setSelectedCollector(CompanyEbfApi selectedCollector) {
        this.selectedCollector = selectedCollector;
    }

    public List<CompanyEbfApi> getOwners() {
        return owners;
    }

    public void setOwners(List<CompanyEbfApi> owners) {
        this.owners = owners;
    }

    public List<CompanyEbfApi> getCollectors() {
        return collectors;
    }

    public void setCollectors(List<CompanyEbfApi> collectors) {
        this.collectors = collectors;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Override
    public String toString() {
        return "SessionEbfApi ["
                + ((operatorEbfApi != null) ? "operatorEbfApi=" + operatorEbfApi + ", " : "")
                + ((rightSetEbfApi != null) ? "rightSetEbfApi=" + rightSetEbfApi + ", " : "")
                + ((processDate != null) ? "processDate=" + processDate + ", " : "")
                + ((allOwnersPaymentReasonTypes != null) ? "allOwnersPaymentReasonTypes=" + Arrays.toString(allOwnersPaymentReasonTypes.toArray()) + ", " : "")
                + ((selectedOwner != null) ? "selectedOwner=" + selectedOwner + ", " : "")
                + ((selectedCollector != null) ? "selectedCollector=" + selectedCollector + ", " : "")
                + ((owners != null) ? "owners=" + Arrays.toString(owners.toArray()) + ", " : "")
                + ((collectors != null) ? "collectors=" + Arrays.toString(collectors.toArray()) + ", " : "")
                + ((relationType != null) ? "relationType=" + relationType : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SessionEbfApi that = (SessionEbfApi) o;

        if (operatorEbfApi != null ? !operatorEbfApi.equals(that.operatorEbfApi) : that.operatorEbfApi != null) return false;
        if (rightSetEbfApi != null ? !rightSetEbfApi.equals(that.rightSetEbfApi) : that.rightSetEbfApi != null) return false;
        if (processDate != null ? !processDate.equals(that.processDate) : that.processDate != null) return false;
        if (allOwnersPaymentReasonTypes != null ? !allOwnersPaymentReasonTypes.equals(that.allOwnersPaymentReasonTypes) : that.allOwnersPaymentReasonTypes != null) return false;
        if (selectedOwner != null ? !selectedOwner.equals(that.selectedOwner) : that.selectedOwner != null) return false;
        if (selectedCollector != null ? !selectedCollector.equals(that.selectedCollector) : that.selectedCollector != null) return false;
        if (owners != null ? !owners.equals(that.owners) : that.owners != null) return false;
        if (collectors != null ? !collectors.equals(that.collectors) : that.collectors != null) return false;
        return relationType != null ? relationType.equals(that.relationType) : that.relationType == null;
    }

    @Override
    public int hashCode() {
        int result = operatorEbfApi != null ? operatorEbfApi.hashCode() : 0;
        result = 31 * result + (rightSetEbfApi != null ? rightSetEbfApi.hashCode() : 0);
        result = 31 * result + (processDate != null ? processDate.hashCode() : 0);
        result = 31 * result + (allOwnersPaymentReasonTypes != null ? allOwnersPaymentReasonTypes.hashCode() : 0);
        result = 31 * result + (selectedOwner != null ? selectedOwner.hashCode() : 0);
        result = 31 * result + (selectedCollector != null ? selectedCollector.hashCode() : 0);
        result = 31 * result + (owners != null ? owners.hashCode() : 0);
        result = 31 * result + (collectors != null ? collectors.hashCode() : 0);
        result = 31 * result + (relationType != null ? relationType.hashCode() : 0);
        return result;
    }
}
