package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentDocumentEbfApi implements Serializable {

    private String paymentUid;
    private DocumentEbfApi dpg;
    private List<DocumentEbfApi> payables;
    private List<DocumentEbfApi> instruments;
    private List<DocumentEbfApi> deductions;
    private List<DocumentEbfApi> retentions;
    private List<SettlementEbfApi> settlements;
    private String optionCodes;

    public String getPaymentUid() {
        return paymentUid;
    }

    public void setPaymentUid(String paymentUid) {
        this.paymentUid = paymentUid;
    }

    public DocumentEbfApi getDpg() {
        return dpg;
    }

    public void setDpg(DocumentEbfApi dpg) {
        this.dpg = dpg;
    }

    public List<DocumentEbfApi> getPayables() {
        return payables;
    }

    public void setPayables(List<DocumentEbfApi> payables) {
        this.payables = payables;
    }

    public List<DocumentEbfApi> getInstruments() {
        return instruments;
    }

    public void setInstruments(List<DocumentEbfApi> instruments) {
        this.instruments = instruments;
    }

    public List<DocumentEbfApi> getDeductions() {
        return deductions;
    }

    public void setDeductions(List<DocumentEbfApi> deductions) {
        this.deductions = deductions;
    }

    public List<DocumentEbfApi> getRetentions() {
        return retentions;
    }

    public void setRetentions(List<DocumentEbfApi> retentions) {
        this.retentions = retentions;
    }

    public List<SettlementEbfApi> getSettlements() {
        return settlements;
    }

    public void setSettlements(List<SettlementEbfApi> settlements) {
        this.settlements = settlements;
    }

    public String getOptionCodes() {
        return optionCodes;
    }

    public void setOptionCodes(String optionCodes) {
        this.optionCodes = optionCodes;
    }

    @Override
    public String toString() {
        return "PaymentDocumentEbfApi ["
                + ((paymentUid != null) ? "paymentUid=" + paymentUid + ", " : "")
                + ((dpg != null) ? "dpg=" + dpg + ", " : "")
                + ((payables != null) ? "payables=" + Arrays.toString(payables.toArray()) + ", " : "")
                + ((instruments != null) ? "instruments=" + Arrays.toString(instruments.toArray()) + ", " : "")
                + ((deductions != null) ? "deductions=" + Arrays.toString(deductions.toArray()) + ", " : "")
                + ((retentions != null) ? "retentions=" + Arrays.toString(retentions.toArray()) + ", " : "")
                + ((settlements != null) ? "settlements=" + Arrays.toString(settlements.toArray()) + ", " : "")
                + ((optionCodes != null) ? "optionCodes=" + optionCodes : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentDocumentEbfApi that = (PaymentDocumentEbfApi) o;

        if (paymentUid != null ? !paymentUid.equals(that.paymentUid) : that.paymentUid != null) return false;
        if (dpg != null ? !dpg.equals(that.dpg) : that.dpg != null) return false;
        if (payables != null ? !payables.equals(that.payables) : that.payables != null) return false;
        if (instruments != null ? !instruments.equals(that.instruments) : that.instruments != null) return false;
        if (deductions != null ? !deductions.equals(that.deductions) : that.deductions != null) return false;
        if (retentions != null ? !retentions.equals(that.retentions) : that.retentions != null) return false;
        if (settlements != null ? !settlements.equals(that.settlements) : that.settlements != null) return false;
        return optionCodes != null ? optionCodes.equals(that.optionCodes) : that.optionCodes == null;
    }

    @Override
    public int hashCode() {
        int result = paymentUid != null ? paymentUid.hashCode() : 0;
        result = 31 * result + (dpg != null ? dpg.hashCode() : 0);
        result = 31 * result + (payables != null ? payables.hashCode() : 0);
        result = 31 * result + (instruments != null ? instruments.hashCode() : 0);
        result = 31 * result + (deductions != null ? deductions.hashCode() : 0);
        result = 31 * result + (retentions != null ? retentions.hashCode() : 0);
        result = 31 * result + (settlements != null ? settlements.hashCode() : 0);
        result = 31 * result + (optionCodes != null ? optionCodes.hashCode() : 0);
        return result;
    }
}
