package ar.com.sdd.ebfapi.client.model.contrato.inba;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Transferencia {

    private String descripMotivoRechazo;
    private String cuitPagador;
    private String cuitDeudor;
    private String recaudador;
    private String observacionTef;
    private String numeroCuentaRecaudacion;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private String fechaPago;
    private Long numeroRedIB;
    private Long numeroInterno;
    private String monedaTransferencia;
    private String codBancoCredito;
    private BigDecimal importe;
    private String estadoParaComunidad;
    private String cuitCuentaRecaudacion;
    private String nroComprobante;
    private Long nroIdentificadorDeDeuda;

    public String getDescripMotivoRechazo() {
        return descripMotivoRechazo;
    }

    public void setDescripMotivoRechazo(String descripMotivoRechazo) {
        this.descripMotivoRechazo = descripMotivoRechazo;
    }

    public String getCuitPagador() {
        return cuitPagador;
    }

    public void setCuitPagador(String cuitPagador) {
        this.cuitPagador = cuitPagador;
    }

    public String getCuitDeudor() {
        return cuitDeudor;
    }

    public void setCuitDeudor(String cuitDeudor) {
        this.cuitDeudor = cuitDeudor;
    }

    public String getRecaudador() {
        return recaudador;
    }

    public void setRecaudador(String recaudador) {
        this.recaudador = recaudador;
    }

    public String getObservacionTef() {
        return observacionTef;
    }

    public void setObservacionTef(String observacionTef) {
        this.observacionTef = observacionTef;
    }

    public String getNumeroCuentaRecaudacion() {
        return numeroCuentaRecaudacion;
    }

    public void setNumeroCuentaRecaudacion(String numeroCuentaRecaudacion) {
        this.numeroCuentaRecaudacion = numeroCuentaRecaudacion;
    }

    public String getFechaPago() {
        return fechaPago;
    }

    public void setFechaPago(String fechaPago) {
        this.fechaPago = fechaPago;
    }

    public Long getNumeroRedIB() {
        return numeroRedIB;
    }

    public void setNumeroRedIB(Long numeroRedIB) {
        this.numeroRedIB = numeroRedIB;
    }

    public Long getNumeroInterno() {
        return numeroInterno;
    }

    public void setNumeroInterno(Long numeroInterno) {
        this.numeroInterno = numeroInterno;
    }

    public String getMonedaTransferencia() {
        return monedaTransferencia;
    }

    public void setMonedaTransferencia(String monedaTransferencia) {
        this.monedaTransferencia = monedaTransferencia;
    }

    public String getCodBancoCredito() {
        return codBancoCredito;
    }

    public void setCodBancoCredito(String codBancoCredito) {
        this.codBancoCredito = codBancoCredito;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getEstadoParaComunidad() {
        return estadoParaComunidad;
    }

    public void setEstadoParaComunidad(String estadoParaComunidad) {
        this.estadoParaComunidad = estadoParaComunidad;
    }

    public String getCuitCuentaRecaudacion() {
        return cuitCuentaRecaudacion;
    }

    public void setCuitCuentaRecaudacion(String cuitCuentaRecaudacion) {
        this.cuitCuentaRecaudacion = cuitCuentaRecaudacion;
    }

    public String getNroComprobante() {
        return nroComprobante;
    }

    public void setNroComprobante(String nroComprobante) {
        this.nroComprobante = nroComprobante;
    }

    public Long getNroIdentificadorDeDeuda() {
        return nroIdentificadorDeDeuda;
    }

    public void setNroIdentificadorDeDeuda(Long nroIdentificadorDeDeuda) {
        this.nroIdentificadorDeDeuda = nroIdentificadorDeDeuda;
    }

    @Override
    public String toString() {
        return "Transferencia ["
                + ((descripMotivoRechazo != null) ? "descripMotivoRechazo=" + descripMotivoRechazo + ", " : "")
                + ((cuitPagador != null) ? "cuitPagador=" + cuitPagador + ", " : "")
                + ((cuitDeudor != null) ? "cuitDeudor=" + cuitDeudor + ", " : "")
                + ((recaudador != null) ? "recaudador=" + recaudador + ", " : "")
                + ((observacionTef != null) ? "observacionTef=" + observacionTef + ", " : "")
                + ((numeroCuentaRecaudacion != null) ? "numeroCuentaRecaudacion=" + numeroCuentaRecaudacion + ", " : "")
                + ((fechaPago != null) ? "fechaPago=" + fechaPago + ", " : "")
                + ((numeroRedIB != null) ? "numeroRedIB=" + numeroRedIB + ", " : "")
                + ((numeroInterno != null) ? "numeroInterno=" + numeroInterno + ", " : "")
                + ((monedaTransferencia != null) ? "monedaTransferencia=" + monedaTransferencia + ", " : "")
                + ((codBancoCredito != null) ? "codBancoCredito=" + codBancoCredito + ", " : "")
                + ((importe != null) ? "importe=" + importe + ", " : "")
                + ((estadoParaComunidad != null) ? "estadoParaComunidad=" + estadoParaComunidad + ", " : "")
                + ((cuitCuentaRecaudacion != null) ? "cuitCuentaRecaudacion=" + cuitCuentaRecaudacion + ", " : "")
                + ((nroComprobante != null) ? "nroComprobante=" + nroComprobante + ", " : "")
                + ((nroIdentificadorDeDeuda != null) ? "nroIdentificadorDeDeuda=" + nroIdentificadorDeDeuda : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Transferencia that = (Transferencia) o;

        if (descripMotivoRechazo != null ? !descripMotivoRechazo.equals(that.descripMotivoRechazo) : that.descripMotivoRechazo != null) return false;
        if (cuitPagador != null ? !cuitPagador.equals(that.cuitPagador) : that.cuitPagador != null) return false;
        if (cuitDeudor != null ? !cuitDeudor.equals(that.cuitDeudor) : that.cuitDeudor != null) return false;
        if (recaudador != null ? !recaudador.equals(that.recaudador) : that.recaudador != null) return false;
        if (observacionTef != null ? !observacionTef.equals(that.observacionTef) : that.observacionTef != null) return false;
        if (numeroCuentaRecaudacion != null ? !numeroCuentaRecaudacion.equals(that.numeroCuentaRecaudacion) : that.numeroCuentaRecaudacion != null) return false;
        if (fechaPago != null ? !fechaPago.equals(that.fechaPago) : that.fechaPago != null) return false;
        if (numeroRedIB != null ? !numeroRedIB.equals(that.numeroRedIB) : that.numeroRedIB != null) return false;
        if (numeroInterno != null ? !numeroInterno.equals(that.numeroInterno) : that.numeroInterno != null) return false;
        if (monedaTransferencia != null ? !monedaTransferencia.equals(that.monedaTransferencia) : that.monedaTransferencia != null) return false;
        if (codBancoCredito != null ? !codBancoCredito.equals(that.codBancoCredito) : that.codBancoCredito != null) return false;
        if (importe != null ? !importe.equals(that.importe) : that.importe != null) return false;
        if (estadoParaComunidad != null ? !estadoParaComunidad.equals(that.estadoParaComunidad) : that.estadoParaComunidad != null) return false;
        if (cuitCuentaRecaudacion != null ? !cuitCuentaRecaudacion.equals(that.cuitCuentaRecaudacion) : that.cuitCuentaRecaudacion != null) return false;
        if (nroComprobante != null ? !nroComprobante.equals(that.nroComprobante) : that.nroComprobante != null) return false;
        return nroIdentificadorDeDeuda != null ? nroIdentificadorDeDeuda.equals(that.nroIdentificadorDeDeuda) : that.nroIdentificadorDeDeuda == null;
    }

    @Override
    public int hashCode() {
        int result = descripMotivoRechazo != null ? descripMotivoRechazo.hashCode() : 0;
        result = 31 * result + (cuitPagador != null ? cuitPagador.hashCode() : 0);
        result = 31 * result + (cuitDeudor != null ? cuitDeudor.hashCode() : 0);
        result = 31 * result + (recaudador != null ? recaudador.hashCode() : 0);
        result = 31 * result + (observacionTef != null ? observacionTef.hashCode() : 0);
        result = 31 * result + (numeroCuentaRecaudacion != null ? numeroCuentaRecaudacion.hashCode() : 0);
        result = 31 * result + (fechaPago != null ? fechaPago.hashCode() : 0);
        result = 31 * result + (numeroRedIB != null ? numeroRedIB.hashCode() : 0);
        result = 31 * result + (numeroInterno != null ? numeroInterno.hashCode() : 0);
        result = 31 * result + (monedaTransferencia != null ? monedaTransferencia.hashCode() : 0);
        result = 31 * result + (codBancoCredito != null ? codBancoCredito.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (estadoParaComunidad != null ? estadoParaComunidad.hashCode() : 0);
        result = 31 * result + (cuitCuentaRecaudacion != null ? cuitCuentaRecaudacion.hashCode() : 0);
        result = 31 * result + (nroComprobante != null ? nroComprobante.hashCode() : 0);
        result = 31 * result + (nroIdentificadorDeDeuda != null ? nroIdentificadorDeDeuda.hashCode() : 0);
        return result;
    }
}
