package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpCompany implements Serializable {

    private String taxId;
    private String name;
    private String addressStreet;
    private String addressZipcode;
    private String addressCity;
    private String addressRegion;
    private String addressCountry;
    private String group1;
    private String group2;
    private String role;
    private String status;
    private String dato1;
	private String dato2;
	private String dato3;
	private String dato4;
	private String dato5;
	private String dato6;
	private String dato7;
	private String dato8;
	private String dato9;
	private String dato10;
    private List<ErpBussinesUnit> bu;
    private List<ErpDistributor> dist;

    @JsonProperty("taxId")
    @Size(max = 15)
    public String getTaxId() {
        return taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    @JsonProperty("name")
    @Size(max = 40)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("addressStreet")
    @Size(max = 100)
    public String getAddressStreet() {
        return addressStreet;
    }

    public void setAddressStreet(String addressStreet) {
        this.addressStreet = addressStreet;
    }

    @JsonProperty("addressZipcode")
    @Size(max = 10)
    public String getAddressZipcode() {
        return addressZipcode;
    }

    public void setAddressZipcode(String addressZipcode) {
        this.addressZipcode = addressZipcode;
    }

    @JsonProperty("addressCity")
    @Size(max = 40)
    public String getAddressCity() {
        return addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    @JsonProperty("addressRegion")
    @Size(max = 20)
    public String getAddressRegion() {
        return addressRegion;
    }

    public void setAddressRegion(String addressRegion) {
        this.addressRegion = addressRegion;
    }

    @JsonProperty("addressCountry")
    @Size(max = 3)
    public String getAddressCountry() {
        return addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    @JsonProperty("group1")
    @Size(max = 20)
    public String getGroup1() {
        return group1;
    }

    public void setGroup1(String group1) {
        this.group1 = group1;
    }

    @JsonProperty("group2")
    @Size(max = 20)
    public String getGroup2() {
        return group2;
    }

    public void setGroup2(String group2) {
        this.group2 = group2;
    }

    @JsonProperty("role")
    @Size(max = 1)
    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }


    @JsonProperty("status")
    @Size(max = 10)
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    @JsonProperty("dato1")
	@Size(max = 10)
	public String getDato1() {
		return dato1;
	}

	public void setDato1(String dato1) {
		this.dato1 = dato1;
	}

	@JsonProperty("dato2")
	@Size(max = 10)
	public String getDato2() {
		return dato2;
	}

	public void setDato2(String dato2) {
		this.dato2 = dato2;
	}

	@JsonProperty("dato3")
	@Size(max = 10)
	public String getDato3() {
		return dato3;
	}

	public void setDato3(String dato3) {
		this.dato3 = dato3;
	}

	@JsonProperty("dato4")
	@Size(max = 10)
	public String getDato4() {
		return dato4;
	}

	public void setDato4(String dato4) {
		this.dato4 = dato4;
	}

	@JsonProperty("dato5")
	@Size(max = 10)
	public String getDato5() {
		return dato5;
	}

	public void setDato5(String dato5) {
		this.dato5 = dato5;
	}

	@JsonProperty("dato6")
	@Size(max = 10)
	public String getDato6() {
		return dato6;
	}

	public void setDato6(String dato6) {
		this.dato6 = dato6;
	}

	@JsonProperty("dato7")
	@Size(max = 10)
	public String getDato7() {
		return dato7;
	}

	public void setDato7(String dato7) {
		this.dato7 = dato7;
	}

	@JsonProperty("dato8")
	@Size(max = 10)
	public String getDato8() {
		return dato8;
	}

	public void setDato8(String dato8) {
		this.dato8 = dato8;
	}

	@JsonProperty("dato9")
	@Size(max = 10)
	public String getDato9() {
		return dato9;
	}

	public void setDato9(String dato9) {
		this.dato9 = dato9;
	}

	@JsonProperty("dato10")
	@Size(max = 10)
	public String getDato10() {
		return dato10;
	}

	public void setDato10(String dato10) {
		this.dato10 = dato10;
	}

    @JsonProperty("bu")
    public List<ErpBussinesUnit> getBu() {
        return bu;
    }

    public void setBu(List<ErpBussinesUnit> bu) {
        this.bu = bu;
    }

    @JsonProperty("dist")
    public List<ErpDistributor> getDist() {
        return dist;
    }

    public void setDist(List<ErpDistributor> dist) {
        this.dist = dist;
    }

    @Override
    public String toString() {
        return "ErpCompany [" +
                "taxId=" + taxId +
                ", name=" + name +
                ", addressStreet=" + addressStreet +
                ", addressZipcode=" + addressZipcode +
                ", addressCity=" + addressCity +
                ", addressRegion=" + addressRegion +
                ", addressCountry=" + addressCountry +
                ", group1=" + group1 +
                ", group2=" + group2 +
                ", role=" + role +
                ", status=" + status +
                ", dato1=" + dato1 +
                ", dato2=" + dato2 +
                ", dato3=" + dato3 +
                ", dato4=" + dato4 +
                ", dato5=" + dato5 +
                ", dato6=" + dato6 +
                ", dato7=" + dato7 +
                ", dato8=" + dato8 +
                ", dato9=" + dato9 +
                ", dato10=" + dato10 +
                ", bu=" + (bu == null ? bu : Arrays.toString(bu.toArray())) +
                ", dist=" + (dist == null ? dist : Arrays.toString(dist.toArray())) +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpCompany that = (ErpCompany) o;
        return Objects.equals(taxId, that.taxId) && Objects.equals(name, that.name) && Objects.equals(addressStreet, that.addressStreet) && Objects.equals(addressZipcode, that.addressZipcode) && Objects.equals(addressCity, that.addressCity) && Objects.equals(addressRegion, that.addressRegion) && Objects.equals(addressCountry, that.addressCountry) && Objects.equals(group1, that.group1) && Objects.equals(group2, that.group2) && Objects.equals(role, that.role) && Objects.equals(status, that.status) && Objects.equals(dato1, that.dato1) && Objects.equals(dato2, that.dato2) && Objects.equals(dato3, that.dato3) && Objects.equals(dato4, that.dato4) && Objects.equals(dato5, that.dato5) && Objects.equals(dato6, that.dato6) && Objects.equals(dato7, that.dato7) && Objects.equals(dato8, that.dato8) && Objects.equals(dato9, that.dato9) && Objects.equals(dato10, that.dato10) && Objects.equals(bu, that.bu) && Objects.equals(dist, that.dist);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taxId, name, addressStreet, addressZipcode, addressCity, addressRegion, addressCountry, group1, group2, role, status, dato1, dato2, dato3, dato4, dato5, dato6, dato7, dato8, dato9, dato10, bu, dist);
    }
}
