package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocumentComment implements  Serializable{
  private String biller;
  private String payerCuit;
  private String payerCode;
  private String ownerType;
  private String ownerDocRef;
  private String legalDocRef;
  @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
  private Date  issueDate;
  private BigDecimal totalAmount;
  private BigDecimal totalAmountUSD;
  private BigDecimal exchangeRate;
  private List<ErpDocumentCommentDetail> detail = null;

    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalAmountUSD() {
        return totalAmountUSD;
    }

    public void setTotalAmountUSD(BigDecimal totalAmountUSD) {
        this.totalAmountUSD = totalAmountUSD;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public List<ErpDocumentCommentDetail> getDetail() {
        return detail;
    }

    public void setDetail(List<ErpDocumentCommentDetail> detail) {
        this.detail = detail;
    }

    @Override
    public String toString() {
        return "ErpDocumentComment [" +
                "biller=" + biller +
                ", payerCuit=" + payerCuit +
                ", payerCode=" + payerCode +
                ", ownerType=" + ownerType +
                ", ownerDocRef=" + ownerDocRef +
                ", legalDocRef=" + legalDocRef +
                ", issueDate=" + issueDate +
                ", totalAmount=" + totalAmount +
                ", totalAmountUSD=" + totalAmountUSD +
                ", exchangeRate=" + exchangeRate +
                ", detail=" + (detail == null ? detail : Arrays.toString(detail.toArray())) +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErpDocumentComment that = (ErpDocumentComment) o;

        if (!Objects.equals(biller, that.biller)) return false;
        if (!Objects.equals(payerCuit, that.payerCuit)) return false;
        if (!Objects.equals(payerCode, that.payerCode)) return false;
        if (!Objects.equals(ownerType, that.ownerType)) return false;
        if (!Objects.equals(ownerDocRef, that.ownerDocRef)) return false;
        if (!Objects.equals(legalDocRef, that.legalDocRef)) return false;
        if (!Objects.equals(issueDate, that.issueDate)) return false;
        if (!Objects.equals(totalAmount, that.totalAmount)) return false;
        if (!Objects.equals(totalAmountUSD, that.totalAmountUSD)) return false;
        if (!Objects.equals(exchangeRate, that.exchangeRate)) return false;
        return Objects.equals(detail, that.detail);
    }

    @Override
    public int hashCode() {
        int result = biller != null ? biller.hashCode() : 0;
        result = 31 * result + (payerCuit != null ? payerCuit.hashCode() : 0);
        result = 31 * result + (payerCode != null ? payerCode.hashCode() : 0);
        result = 31 * result + (ownerType != null ? ownerType.hashCode() : 0);
        result = 31 * result + (ownerDocRef != null ? ownerDocRef.hashCode() : 0);
        result = 31 * result + (legalDocRef != null ? legalDocRef.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (totalAmount != null ? totalAmount.hashCode() : 0);
        result = 31 * result + (totalAmountUSD != null ? totalAmountUSD.hashCode() : 0);
        result = 31 * result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
        result = 31 * result + (detail != null ? detail.hashCode() : 0);
        return result;
    }
}

