package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DocumentEbfApi implements Serializable {

    private String uid;
    private String type;
    private String typeResource;
    private String subtype;
    private CompanyEbfApi owner;
    private CompanyEbfApi payer;
    private String ownerDocRef;
    private String ownerDocRef2;
    private String legalDocRef;
    private Date issueDate;
    private Date dueDate;
    private Date creditDate;
    private Date creationDate;
    private Timestamp creationTimestamp;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private String currency;
    private String status;
    private String statusResource;
    private String reason;
    private String reasonName;
    private String reasonDescription;
    private String reasonResource;
    private CompanyAccountEbfApi collectorAccount;
    private BankEbfApi issuerBank;
    private String comments;
    private String billingAddress;
    private String biltoName;
    private String editCodes;
    private Integer visibility;
    private String issuerName;
    private String postalCode;
    private BigDecimal financialDiscount1;
    private CompanyEbfApi division;
    private String curr1Currency;
    private String ownerSubtype;
    private String termName1;
    private String paymentTerms;
    private String ownerType;
    private String refNumber;
    private Date deliveryDate;
    private BigDecimal curr1DueAmount;
    private EbfApiConst.AckStatus ackStatus;
    private String ackStatusMessage;
    private String printCodes;
    private String externalSystemReference;

    //Campos extra
    private boolean selected;

    public DocumentEbfApi() {
    }

    public DocumentEbfApi(String uid, String type, CompanyEbfApi owner, CompanyEbfApi payer, String legalDocRef, Date dueDate, BigDecimal dueAmount) {
        this.uid = uid;
        this.type = type;
        this.owner = owner;
        this.payer = payer;
        this.legalDocRef = legalDocRef;
        this.dueDate = dueDate;
        this.dueAmount = dueAmount;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeResource() {
        return typeResource;
    }

    public void setTypeResource(String typeResource) {
        this.typeResource = typeResource;
    }

    public String getSubtype() {
        return subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public CompanyEbfApi getOwner() {
        return owner;
    }

    public void setOwner(CompanyEbfApi owner) {
        this.owner = owner;
    }

    public CompanyEbfApi getPayer() {
        return payer;
    }

    public void setPayer(CompanyEbfApi payer) {
        this.payer = payer;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getOwnerDocRef2() {
        return ownerDocRef2;
    }

    public void setOwnerDocRef2(String ownerDocRef2) {
        this.ownerDocRef2 = ownerDocRef2;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Timestamp getCreationTimestamp() {
        return creationTimestamp;
    }

    public void setCreationTimestamp(Timestamp creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusResource() {
        return statusResource;
    }

    public void setStatusResource(String statusResource) {
        this.statusResource = statusResource;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReasonName() {
        return reasonName;
    }

    public void setReasonName(String reasonName) {
        this.reasonName = reasonName;
    }

    public String getReasonDescription() {
        return reasonDescription;
    }

    public void setReasonDescription(String reasonDescription) {
        this.reasonDescription = reasonDescription;
    }

    public String getReasonResource() {
        return reasonResource;
    }

    public void setReasonResource(String reasonResource) {
        this.reasonResource = reasonResource;
    }

    public CompanyAccountEbfApi getCollectorAccount() {
        return collectorAccount;
    }

    public void setCollectorAccount(CompanyAccountEbfApi collectorAccount) {
        this.collectorAccount = collectorAccount;
    }

    public BankEbfApi getIssuerBank() {
        return issuerBank;
    }

    public void setIssuerBank(BankEbfApi issuerBank) {
        this.issuerBank = issuerBank;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getBiltoName() {
        return biltoName;
    }

    public void setBiltoName(String biltoName) {
        this.biltoName = biltoName;
    }

    public String getEditCodes() {
        return editCodes;
    }

    public void setEditCodes(String editCodes) {
        this.editCodes = editCodes;
    }

    public Integer getVisibility() {
        return visibility;
    }

    public void setVisibility(Integer visibility) {
        this.visibility = visibility;
    }

    public String getIssuerName() {
        return issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public BigDecimal getFinancialDiscount1() {
        return financialDiscount1;
    }

    public void setFinancialDiscount1(BigDecimal financialDiscount1) {
        this.financialDiscount1 = financialDiscount1;
    }

    public CompanyEbfApi getDivision() {
        return division;
    }

    public void setDivision(CompanyEbfApi division) {
        this.division = division;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getCurr1Currency() {
        return curr1Currency;
    }

    public void setCurr1Currency(String curr1Currency) {
        this.curr1Currency = curr1Currency;
    }

    public String getOwnerSubtype() {
        return ownerSubtype;
    }

    public void setOwnerSubtype(String ownerSubtype) {
        this.ownerSubtype = ownerSubtype;
    }

    public String getTermName1() {
        return termName1;
    }

    public void setTermName1(String termName1) {
        this.termName1 = termName1;
    }

    public String getPaymentTerms() {
        return paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getRefNumber() {
        return refNumber;
    }

    public void setRefNumber(String refNumber) {
        this.refNumber = refNumber;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public BigDecimal getCurr1DueAmount() {
        return curr1DueAmount;
    }

    public void setCurr1DueAmount(BigDecimal curr1DueAmount) {
        this.curr1DueAmount = curr1DueAmount;
    }

    public EbfApiConst.AckStatus getAckStatus() {
        return ackStatus;
    }

    public void setAckStatus(EbfApiConst.AckStatus ackStatus) {
        this.ackStatus = ackStatus;
    }

    public String getAckStatusMessage() {
        return ackStatusMessage;
    }

    public void setAckStatusMessage(String ackStatusMessage) {
        this.ackStatusMessage = ackStatusMessage;
    }

    public String getPrintCodes() {
        return printCodes;
    }

    public void setPrintCodes(String printCodes) {
        this.printCodes = printCodes;
    }

    public String getExternalSystemReference() {
        return externalSystemReference;
    }

    public void setExternalSystemReference(String externalSystemReference) {
        this.externalSystemReference = externalSystemReference;
    }

    @Override
    public String toString() {
        return "DocumentEbfApi [" +
                ((uid != null) ? "uid='" + uid + "', " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                ((typeResource != null) ? "typeResource='" + typeResource + "', " : "") +
                ((subtype != null) ? "subtype='" + subtype + "', " : "") +
                ((owner != null) ? "owner=" + owner + ", " : "") +
                ((payer != null) ? "payer=" + payer + ", " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((ownerDocRef2 != null) ? "ownerDocRef2='" + ownerDocRef2 + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((issueDate != null) ? "issueDate=" + issueDate + ", " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((creditDate != null) ? "creditDate=" + creditDate + ", " : "") +
                ((creationDate != null) ? "creationDate=" + creationDate + ", " : "") +
                ((creationTimestamp != null) ? "creationTimestamp=" + creationTimestamp + ", " : "") +
                ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "") +
                ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((statusResource != null) ? "statusResource='" + statusResource + "', " : "") +
                ((reason != null) ? "reason='" + reason + "', " : "") +
                ((reasonName != null) ? "reasonName='" + reasonName + "', " : "") +
                ((reasonDescription != null) ? "reasonDescription='" + reasonDescription + "', " : "") +
                ((reasonResource != null) ? "reasonResource='" + reasonResource + "', " : "") +
                ((collectorAccount != null) ? "collectorAccount=" + collectorAccount + ", " : "") +
                ((issuerBank != null) ? "issuerBank=" + issuerBank + ", " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((billingAddress != null) ? "billingAddress='" + billingAddress + "', " : "") +
                ((biltoName != null) ? "biltoName='" + biltoName + "', " : "") +
                ((editCodes != null) ? "editCodes='" + editCodes + "', " : "") +
                ((visibility != null) ? "visibility=" + visibility + ", " : "") +
                ((issuerName != null) ? "issuerName='" + issuerName + "', " : "") +
                ((postalCode != null) ? "postalCode='" + postalCode + "', " : "") +
                ((financialDiscount1 != null) ? "financialDiscount1=" + financialDiscount1 + ", " : "") +
                ((division != null) ? "division=" + division + ", " : "") +
                ((curr1Currency != null) ? "curr1Currency='" + curr1Currency + "', " : "") +
                ((ownerSubtype != null) ? "ownerSubtype='" + ownerSubtype + "', " : "") +
                ((termName1 != null) ? "termName1='" + termName1 + "', " : "") +
                ((paymentTerms != null) ? "paymentTerms='" + paymentTerms + "', " : "") +
                ((ownerType != null) ? "ownerType='" + ownerType + "', " : "") +
                ((refNumber != null) ? "refNumber='" + refNumber + "', " : "") +
                ((deliveryDate != null) ? "deliveryDate=" + deliveryDate + ", " : "") +
                ((curr1DueAmount != null) ? "curr1DueAmount=" + curr1DueAmount + ", " : "") +
                ((ackStatus != null) ? "ackStatus=" + ackStatus + ", " : "") +
                ((ackStatusMessage != null) ? "ackStatusMessage='" + ackStatusMessage + "', " : "") +
                ((printCodes != null) ? "printCodes='" + printCodes + "', " : "") +
                ((externalSystemReference != null) ? "externalSystemReference='" + externalSystemReference + "', " : "") +
                "selected=" + selected + ", " +
                "]";
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocumentEbfApi that = (DocumentEbfApi) o;
        return selected == that.selected && Objects.equals(uid, that.uid) && Objects.equals(type, that.type) && Objects.equals(typeResource, that.typeResource) && Objects.equals(subtype, that.subtype) && Objects.equals(owner, that.owner) && Objects.equals(payer, that.payer) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(ownerDocRef2, that.ownerDocRef2) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(issueDate, that.issueDate) && Objects.equals(dueDate, that.dueDate) && Objects.equals(creditDate, that.creditDate) && Objects.equals(creationDate, that.creationDate) && Objects.equals(creationTimestamp, that.creationTimestamp) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(dueAmount, that.dueAmount) && Objects.equals(currency, that.currency) && Objects.equals(status, that.status) && Objects.equals(statusResource, that.statusResource) && Objects.equals(reason, that.reason) && Objects.equals(reasonName, that.reasonName) && Objects.equals(reasonDescription, that.reasonDescription) && Objects.equals(reasonResource, that.reasonResource) && Objects.equals(collectorAccount, that.collectorAccount) && Objects.equals(issuerBank, that.issuerBank) && Objects.equals(comments, that.comments) && Objects.equals(billingAddress, that.billingAddress) && Objects.equals(biltoName, that.biltoName) && Objects.equals(editCodes, that.editCodes) && Objects.equals(visibility, that.visibility) && Objects.equals(issuerName, that.issuerName) && Objects.equals(postalCode, that.postalCode) && Objects.equals(financialDiscount1, that.financialDiscount1) && Objects.equals(division, that.division) && Objects.equals(curr1Currency, that.curr1Currency) && Objects.equals(ownerSubtype, that.ownerSubtype) && Objects.equals(termName1, that.termName1) && Objects.equals(paymentTerms, that.paymentTerms) && Objects.equals(ownerType, that.ownerType) && Objects.equals(refNumber, that.refNumber) && Objects.equals(deliveryDate, that.deliveryDate) && Objects.equals(curr1DueAmount, that.curr1DueAmount) && ackStatus == that.ackStatus && Objects.equals(ackStatusMessage, that.ackStatusMessage) && Objects.equals(printCodes, that.printCodes) && Objects.equals(externalSystemReference, that.externalSystemReference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, type, typeResource, subtype, owner, payer, ownerDocRef, ownerDocRef2, legalDocRef, issueDate, dueDate, creditDate, creationDate, creationTimestamp, totalAmount, dueAmount, currency, status, statusResource, reason, reasonName, reasonDescription, reasonResource, collectorAccount, issuerBank, comments, billingAddress, biltoName, editCodes, visibility, issuerName, postalCode, financialDiscount1, division, curr1Currency, ownerSubtype, termName1, paymentTerms, ownerType, refNumber, deliveryDate, curr1DueAmount, ackStatus, ackStatusMessage, printCodes, externalSystemReference, selected);
    }
}