package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RightSetEbfApi implements Serializable {

    private static final String ALL_RIGHTS = "*";
    private static final String ALL_RIGHTS_ALT = "|*|";
    private static final String TAG_ACCESS = "ACCESS";
    private static final String TAG_CONFIG = "CONFIG";
    private static final String DISABLED = "DISABLED";
    private boolean hasAccessToOtherCuits;
    /*Esto esta copiado de RightSet*/
    private Map localRights;
    private Map effectiveRights;
    private String grupos; //Es el mismo campo que en RightSet

    /* de StringUtil */
    private static boolean isListAny(String listItems) {
        if (listItems.equals("*"))
            return true;
        if (listItems.equals("|*|"))
            return true;
        return false;
    }

    private Map getAnyTypeTable(Map topLevel, String type) {
        Map result = (Map) topLevel.get(type);
        if (result == null) {
            throw new RuntimeException("Error en RightSetWAPI: type no soportado:" + type);
        }
        return result;
    }

    private String getAnyRight(Map topLevel, String type, String tag) {
        return (String) getAnyTypeTable(topLevel, type).get(tag);
    }

    /* de StringUtil */
    private boolean isInList(String listItems, String item, boolean allowPrefix) {
        boolean isInItems = false;
        if (listItems != null && item != null) {
            if (isListAny(listItems)) {
                isInItems = true;
            } else {
                StringTokenizer stDocTypes = new StringTokenizer(listItems, "|", false);
                while (stDocTypes.hasMoreTokens() && !isInItems) {
                    String token = stDocTypes.nextToken();
                    isInItems = allowPrefix ? item.startsWith(token) : item.equals(token);
                }
            }
        }
        return isInItems;
    }


    private boolean hasAnyRight(Map topLevel, String type, String tag, String value) {
        boolean retVal = false;

        if (value == null || "".equals(value)) {
            retVal = hasAnyRight(topLevel, type, tag);
        } else {
            String tagValue = getAnyRight(topLevel, type, tag);
            if (tagValue == null) retVal = false;
            else if (ALL_RIGHTS.equals(tagValue) || ALL_RIGHTS_ALT.equals(tagValue)) retVal = true;
            else {
                boolean newv = isInList(tagValue, value, false);
                retVal = newv;
            }
        }
        return retVal;
    }

    private boolean hasAnyRight(Map topLevel, String type, String tag) {
        Object val = getAnyTypeTable(topLevel, type).get(tag);
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            return !((String) val).equals(DISABLED);
        } else {
            return true;
        }
    }

    private boolean hasEffectiveRight(String type, String tag) {
        return hasAnyRight(effectiveRights, type, tag);
    }

    private boolean hasAccessEffective(String tag) {
        return hasEffectiveRight(TAG_ACCESS, tag);
    }

    private boolean hasLocalRight(String type, String tag) {
        return hasAnyRight(localRights, type, tag);
    }

    private boolean hasAccessLocal(String tag) {
        return hasLocalRight(TAG_ACCESS, tag);
    }


    private boolean hasEffectiveRight(String type, String tag, String value) {
        return hasAnyRight(effectiveRights, type, tag, value);
    }

    private boolean hasConfigEffective(String tag, String value) {
        return hasEffectiveRight(TAG_CONFIG, tag, value);
    }

    private boolean hasLocalRight(String type, String tag, String value) {
        return hasAnyRight(localRights, type, tag, value);
    }

    private boolean hasConfigLocal(String tag, String value) {
        return hasLocalRight(TAG_CONFIG, tag, value);
    }


    public boolean hasAccess(String tag) {
        return (hasAccessEffective(tag) || hasAccessLocal(tag));
    }

    public boolean hasConfig(String tag, String value) {
        return (hasConfigEffective(tag, value) || hasConfigLocal(tag, value));
    }


    private String getEffectiveRight(String type, String tag) {
        return getAnyRight(effectiveRights, type, tag);
    }

    private String getLocalRight(String type, String tag) {
        return getAnyRight(localRights, type, tag);
    }

    public String getConfigEffective(String tag) {
        return getEffectiveRight(TAG_CONFIG, tag);
    }

    public String getConfigLocal(String tag) {
        return getLocalRight(TAG_CONFIG, tag);
    }

    public String getConfig(String tag) {
        String val = getConfigEffective(tag);
        if (val == null) val = getConfigLocal(tag);

        return val;
    }

    public Map getLocalRights() {
        return localRights;
    }

    public void setLocalRights(Map localRights) {
        this.localRights = localRights;
    }

    public Map getEffectiveRights() {
        return effectiveRights;
    }

    public void setEffectiveRights(Map effectiveRights) {
        this.effectiveRights = effectiveRights;
    }

    public boolean getHasAccessToOtherCuits() {
        return hasAccessToOtherCuits;
    }

    public void setHasAccessToOtherCuits(boolean hasAccessToOtherCuits) {
        this.hasAccessToOtherCuits = hasAccessToOtherCuits;
    }

    public boolean hasAccessToOtherCuits() {
        return hasAccessToOtherCuits;
    }

    public String getAccessGroup() {
        return grupos;
    }

    /**
     * Solo para ser llamado desde RightSet
     *
     * @return
     */
    public void setAccessGroup(String grupos) {
        this.grupos = grupos;
    }


    @Override
    public String toString() {
        return "RightSetEbfApi ["
                + "hasAccessToOtherCuits=" + hasAccessToOtherCuits + ", "
                + ((localRights != null) ? "localRights=" + localRights + ", " : "")
                + ((effectiveRights != null) ? "effectiveRights=" + effectiveRights + ", " : "")
                + ((grupos != null) ? "grupos=" + grupos : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        RightSetEbfApi that = (RightSetEbfApi) o;

        if (hasAccessToOtherCuits != that.hasAccessToOtherCuits) return false;
        if (localRights != null ? !localRights.equals(that.localRights) : that.localRights != null) return false;
        if (effectiveRights != null ? !effectiveRights.equals(that.effectiveRights) : that.effectiveRights != null) return false;
        return grupos != null ? grupos.equals(that.grupos) : that.grupos == null;
    }

    @Override
    public int hashCode() {
        int result = (hasAccessToOtherCuits ? 1 : 0);
        result = 31 * result + (localRights != null ? localRights.hashCode() : 0);
        result = 31 * result + (effectiveRights != null ? effectiveRights.hashCode() : 0);
        result = 31 * result + (grupos != null ? grupos.hashCode() : 0);
        return result;
    }
}
