package ar.com.sdd.ebfapi.client.model.dvp;

import ar.com.sdd.ebfapi.client.model.EbfApiConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DvpPaymentDocument implements Serializable {

    private String idPago;
    private String tipoInstrumento;
    private String vendedorCuit;
    private String vendedorDepositanteFce;
    private String vendedorComitenteFce;
    private String vendedorDepositanteMadreMoneda;
    private String vendedorComitenteMoneda;
    private String vendedorCbuCvu;
    private String compradorCuit;
    private String compradorDepositanteFce;
    private String compradorComitenteFce;
    private String compradorDepositanteMadreMoneda;
    private String compradorComitenteMoneda;
    private String compradorCbuCvu;
    private String agenteCbu;
    private String agenteDepositanteMadreMoneda;
    private String agenteComitenteMoneda;
    private Date fechaHoraConcertacion;
    private String idFceCdv;
    private String idFce;
    private String referenciaPago;
    private String monedaFce;
    private BigDecimal valorNominalFce;
    private String monedaNegociacion;
    private BigDecimal compradorMonto;
    private BigDecimal compradorComisionGastos;
    private BigDecimal vendedorComisionGastos;
    private BigDecimal vendedorMonto;
    private String estado;
    private EbfApiConst.AckStatus ackStatus;
    private String ackStatusMessage;

    public String getIdPago() {
        return idPago;
    }

    public void setIdPago(String idPago) {
        this.idPago = idPago;
    }

    public String getTipoInstrumento() {
        return tipoInstrumento;
    }

    public void setTipoInstrumento(String tipoInstrumento) {
        this.tipoInstrumento = tipoInstrumento;
    }

    public String getVendedorCuit() {
        return vendedorCuit;
    }

    public void setVendedorCuit(String vendedorCuit) {
        this.vendedorCuit = vendedorCuit;
    }

    public String getVendedorDepositanteFce() {
        return vendedorDepositanteFce;
    }

    public void setVendedorDepositanteFce(String vendedorDepositanteFce) {
        this.vendedorDepositanteFce = vendedorDepositanteFce;
    }

    public String getVendedorComitenteFce() {
        return vendedorComitenteFce;
    }

    public void setVendedorComitenteFce(String vendedorComitenteFce) {
        this.vendedorComitenteFce = vendedorComitenteFce;
    }

    public String getVendedorDepositanteMadreMoneda() {
        return vendedorDepositanteMadreMoneda;
    }

    public void setVendedorDepositanteMadreMoneda(String vendedorDepositanteMadreMoneda) {
        this.vendedorDepositanteMadreMoneda = vendedorDepositanteMadreMoneda;
    }

    public String getVendedorComitenteMoneda() {
        return vendedorComitenteMoneda;
    }

    public void setVendedorComitenteMoneda(String vendedorComitenteMoneda) {
        this.vendedorComitenteMoneda = vendedorComitenteMoneda;
    }

    public String getVendedorCbuCvu() {
        return vendedorCbuCvu;
    }

    public void setVendedorCbuCvu(String vendedorCbuCvu) {
        this.vendedorCbuCvu = vendedorCbuCvu;
    }

    public String getCompradorCuit() {
        return compradorCuit;
    }

    public void setCompradorCuit(String compradorCuit) {
        this.compradorCuit = compradorCuit;
    }

    public String getCompradorDepositanteFce() {
        return compradorDepositanteFce;
    }

    public void setCompradorDepositanteFce(String compradorDepositanteFce) {
        this.compradorDepositanteFce = compradorDepositanteFce;
    }

    public String getCompradorComitenteFce() {
        return compradorComitenteFce;
    }

    public void setCompradorComitenteFce(String compradorComitenteFce) {
        this.compradorComitenteFce = compradorComitenteFce;
    }

    public String getCompradorDepositanteMadreMoneda() {
        return compradorDepositanteMadreMoneda;
    }

    public void setCompradorDepositanteMadreMoneda(String compradorDepositanteMadreMoneda) {
        this.compradorDepositanteMadreMoneda = compradorDepositanteMadreMoneda;
    }

    public String getCompradorComitenteMoneda() {
        return compradorComitenteMoneda;
    }

    public void setCompradorComitenteMoneda(String compradorComitenteMoneda) {
        this.compradorComitenteMoneda = compradorComitenteMoneda;
    }

    public String getCompradorCbuCvu() {
        return compradorCbuCvu;
    }

    public void setCompradorCbuCvu(String compradorCbuCvu) {
        this.compradorCbuCvu = compradorCbuCvu;
    }

    public String getAgenteCbu() {
        return agenteCbu;
    }

    public void setAgenteCbu(String agenteCbu) {
        this.agenteCbu = agenteCbu;
    }

    public String getAgenteDepositanteMadreMoneda() {
        return agenteDepositanteMadreMoneda;
    }

    public void setAgenteDepositanteMadreMoneda(String agenteDepositanteMadreMoneda) {
        this.agenteDepositanteMadreMoneda = agenteDepositanteMadreMoneda;
    }

    public String getAgenteComitenteMoneda() {
        return agenteComitenteMoneda;
    }

    public void setAgenteComitenteMoneda(String agenteComitenteMoneda) {
        this.agenteComitenteMoneda = agenteComitenteMoneda;
    }

    public Date getFechaHoraConcertacion() {
        return fechaHoraConcertacion;
    }

    public void setFechaHoraConcertacion(Date fechaHoraConcertacion) {
        this.fechaHoraConcertacion = fechaHoraConcertacion;
    }

    public String getIdFceCdv() {
        return idFceCdv;
    }

    public void setIdFceCdv(String idFceCdv) {
        this.idFceCdv = idFceCdv;
    }

    public String getIdFce() {
        return idFce;
    }

    public void setIdFce(String idFce) {
        this.idFce = idFce;
    }

    public String getReferenciaPago() {
        return referenciaPago;
    }

    public void setReferenciaPago(String referenciaPago) {
        this.referenciaPago = referenciaPago;
    }

    public String getMonedaFce() {
        return monedaFce;
    }

    public void setMonedaFce(String monedaFce) {
        this.monedaFce = monedaFce;
    }

    public BigDecimal getValorNominalFce() {
        return valorNominalFce;
    }

    public void setValorNominalFce(BigDecimal valorNominalFce) {
        this.valorNominalFce = valorNominalFce;
    }

    public String getMonedaNegociacion() {
        return monedaNegociacion;
    }

    public void setMonedaNegociacion(String monedaNegociacion) {
        this.monedaNegociacion = monedaNegociacion;
    }

    public BigDecimal getCompradorMonto() {
        return compradorMonto;
    }

    public void setCompradorMonto(BigDecimal compradorMonto) {
        this.compradorMonto = compradorMonto;
    }

    public BigDecimal getCompradorComisionGastos() {
        return compradorComisionGastos;
    }

    public void setCompradorComisionGastos(BigDecimal compradorComisionGastos) {
        this.compradorComisionGastos = compradorComisionGastos;
    }

    public BigDecimal getVendedorComisionGastos() {
        return vendedorComisionGastos;
    }

    public void setVendedorComisionGastos(BigDecimal vendedorComisionGastos) {
        this.vendedorComisionGastos = vendedorComisionGastos;
    }

    public BigDecimal getVendedorMonto() {
        return vendedorMonto;
    }

    public void setVendedorMonto(BigDecimal vendedorMonto) {
        this.vendedorMonto = vendedorMonto;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public EbfApiConst.AckStatus getAckStatus() {
        return ackStatus;
    }

    public void setAckStatus(EbfApiConst.AckStatus ackStatus) {
        this.ackStatus = ackStatus;
    }

    public String getAckStatusMessage() {
        return ackStatusMessage;
    }

    public void setAckStatusMessage(String ackStatusMessage) {
        this.ackStatusMessage = ackStatusMessage;
    }

    @Override
    public String toString() {
        return "DvpPaymentDocument ["
                + ((idPago != null) ? "idPago=" + idPago + ", " : "")
                + ((tipoInstrumento != null) ? "tipoInstrumento=" + tipoInstrumento + ", " : "")
                + ((vendedorCuit != null) ? "vendedorCuit=" + vendedorCuit + ", " : "")
                + ((vendedorDepositanteFce != null) ? "vendedorDepositanteFce=" + vendedorDepositanteFce + ", " : "")
                + ((vendedorComitenteFce != null) ? "vendedorComitenteFce=" + vendedorComitenteFce + ", " : "")
                + ((vendedorDepositanteMadreMoneda != null) ? "vendedorDepositanteMadreMoneda=" + vendedorDepositanteMadreMoneda + ", " : "")
                + ((vendedorComitenteMoneda != null) ? "vendedorComitenteMoneda=" + vendedorComitenteMoneda + ", " : "")
                + ((vendedorCbuCvu != null) ? "vendedorCbuCvu=" + vendedorCbuCvu + ", " : "")
                + ((compradorCuit != null) ? "compradorCuit=" + compradorCuit + ", " : "")
                + ((compradorDepositanteFce != null) ? "compradorDepositanteFce=" + compradorDepositanteFce + ", " : "")
                + ((compradorComitenteFce != null) ? "compradorComitenteFce=" + compradorComitenteFce + ", " : "")
                + ((compradorDepositanteMadreMoneda != null) ? "compradorDepositanteMadreMoneda=" + compradorDepositanteMadreMoneda + ", " : "")
                + ((compradorComitenteMoneda != null) ? "compradorComitenteMoneda=" + compradorComitenteMoneda + ", " : "")
                + ((compradorCbuCvu != null) ? "compradorCbuCvu=" + compradorCbuCvu + ", " : "")
                + ((agenteCbu != null) ? "agenteCbu=" + agenteCbu + ", " : "")
                + ((agenteDepositanteMadreMoneda != null) ? "agenteDepositanteMadreMoneda=" + agenteDepositanteMadreMoneda + ", " : "")
                + ((agenteComitenteMoneda != null) ? "agenteComitenteMoneda=" + agenteComitenteMoneda + ", " : "")
                + ((fechaHoraConcertacion != null) ? "fechaHoraConcertacion=" + fechaHoraConcertacion + ", " : "")
                + ((idFceCdv != null) ? "idFceCdv=" + idFceCdv + ", " : "")
                + ((idFce != null) ? "idFce=" + idFce + ", " : "")
                + ((referenciaPago != null) ? "referenciaPago=" + referenciaPago + ", " : "")
                + ((monedaFce != null) ? "monedaFce=" + monedaFce + ", " : "")
                + ((valorNominalFce != null) ? "valorNominalFce=" + valorNominalFce + ", " : "")
                + ((monedaNegociacion != null) ? "monedaNegociacion=" + monedaNegociacion + ", " : "")
                + ((compradorMonto != null) ? "compradorMonto=" + compradorMonto + ", " : "")
                + ((compradorComisionGastos != null) ? "compradorComisionGastos=" + compradorComisionGastos + ", " : "")
                + ((vendedorComisionGastos != null) ? "vendedorComisionGastos=" + vendedorComisionGastos + ", " : "")
                + ((vendedorMonto != null) ? "vendedorMonto=" + vendedorMonto + ", " : "")
                + ((estado != null) ? "estado=" + estado + ", " : "")
                + ((ackStatus != null) ? "ackStatus=" + ackStatus + ", " : "")
                + ((ackStatusMessage != null) ? "ackStatusMessage=" + ackStatusMessage : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DvpPaymentDocument that = (DvpPaymentDocument) o;

        if (idPago != null ? !idPago.equals(that.idPago) : that.idPago != null) return false;
        if (tipoInstrumento != null ? !tipoInstrumento.equals(that.tipoInstrumento) : that.tipoInstrumento != null) return false;
        if (vendedorCuit != null ? !vendedorCuit.equals(that.vendedorCuit) : that.vendedorCuit != null) return false;
        if (vendedorDepositanteFce != null ? !vendedorDepositanteFce.equals(that.vendedorDepositanteFce) : that.vendedorDepositanteFce != null) return false;
        if (vendedorComitenteFce != null ? !vendedorComitenteFce.equals(that.vendedorComitenteFce) : that.vendedorComitenteFce != null) return false;
        if (vendedorDepositanteMadreMoneda != null ? !vendedorDepositanteMadreMoneda.equals(that.vendedorDepositanteMadreMoneda) : that.vendedorDepositanteMadreMoneda != null) return false;
        if (vendedorComitenteMoneda != null ? !vendedorComitenteMoneda.equals(that.vendedorComitenteMoneda) : that.vendedorComitenteMoneda != null) return false;
        if (vendedorCbuCvu != null ? !vendedorCbuCvu.equals(that.vendedorCbuCvu) : that.vendedorCbuCvu != null) return false;
        if (compradorCuit != null ? !compradorCuit.equals(that.compradorCuit) : that.compradorCuit != null) return false;
        if (compradorDepositanteFce != null ? !compradorDepositanteFce.equals(that.compradorDepositanteFce) : that.compradorDepositanteFce != null) return false;
        if (compradorComitenteFce != null ? !compradorComitenteFce.equals(that.compradorComitenteFce) : that.compradorComitenteFce != null) return false;
        if (compradorDepositanteMadreMoneda != null ? !compradorDepositanteMadreMoneda.equals(that.compradorDepositanteMadreMoneda) : that.compradorDepositanteMadreMoneda != null) return false;
        if (compradorComitenteMoneda != null ? !compradorComitenteMoneda.equals(that.compradorComitenteMoneda) : that.compradorComitenteMoneda != null) return false;
        if (compradorCbuCvu != null ? !compradorCbuCvu.equals(that.compradorCbuCvu) : that.compradorCbuCvu != null) return false;
        if (agenteCbu != null ? !agenteCbu.equals(that.agenteCbu) : that.agenteCbu != null) return false;
        if (agenteDepositanteMadreMoneda != null ? !agenteDepositanteMadreMoneda.equals(that.agenteDepositanteMadreMoneda) : that.agenteDepositanteMadreMoneda != null) return false;
        if (agenteComitenteMoneda != null ? !agenteComitenteMoneda.equals(that.agenteComitenteMoneda) : that.agenteComitenteMoneda != null) return false;
        if (fechaHoraConcertacion != null ? !fechaHoraConcertacion.equals(that.fechaHoraConcertacion) : that.fechaHoraConcertacion != null) return false;
        if (idFceCdv != null ? !idFceCdv.equals(that.idFceCdv) : that.idFceCdv != null) return false;
        if (idFce != null ? !idFce.equals(that.idFce) : that.idFce != null) return false;
        if (referenciaPago != null ? !referenciaPago.equals(that.referenciaPago) : that.referenciaPago != null) return false;
        if (monedaFce != null ? !monedaFce.equals(that.monedaFce) : that.monedaFce != null) return false;
        if (valorNominalFce != null ? !valorNominalFce.equals(that.valorNominalFce) : that.valorNominalFce != null) return false;
        if (monedaNegociacion != null ? !monedaNegociacion.equals(that.monedaNegociacion) : that.monedaNegociacion != null) return false;
        if (compradorMonto != null ? !compradorMonto.equals(that.compradorMonto) : that.compradorMonto != null) return false;
        if (compradorComisionGastos != null ? !compradorComisionGastos.equals(that.compradorComisionGastos) : that.compradorComisionGastos != null) return false;
        if (vendedorComisionGastos != null ? !vendedorComisionGastos.equals(that.vendedorComisionGastos) : that.vendedorComisionGastos != null) return false;
        if (vendedorMonto != null ? !vendedorMonto.equals(that.vendedorMonto) : that.vendedorMonto != null) return false;
        if (estado != null ? !estado.equals(that.estado) : that.estado != null) return false;
        if (ackStatus != that.ackStatus) return false;
        return ackStatusMessage != null ? ackStatusMessage.equals(that.ackStatusMessage) : that.ackStatusMessage == null;
    }

    @Override
    public int hashCode() {
        int result = idPago != null ? idPago.hashCode() : 0;
        result = 31 * result + (tipoInstrumento != null ? tipoInstrumento.hashCode() : 0);
        result = 31 * result + (vendedorCuit != null ? vendedorCuit.hashCode() : 0);
        result = 31 * result + (vendedorDepositanteFce != null ? vendedorDepositanteFce.hashCode() : 0);
        result = 31 * result + (vendedorComitenteFce != null ? vendedorComitenteFce.hashCode() : 0);
        result = 31 * result + (vendedorDepositanteMadreMoneda != null ? vendedorDepositanteMadreMoneda.hashCode() : 0);
        result = 31 * result + (vendedorComitenteMoneda != null ? vendedorComitenteMoneda.hashCode() : 0);
        result = 31 * result + (vendedorCbuCvu != null ? vendedorCbuCvu.hashCode() : 0);
        result = 31 * result + (compradorCuit != null ? compradorCuit.hashCode() : 0);
        result = 31 * result + (compradorDepositanteFce != null ? compradorDepositanteFce.hashCode() : 0);
        result = 31 * result + (compradorComitenteFce != null ? compradorComitenteFce.hashCode() : 0);
        result = 31 * result + (compradorDepositanteMadreMoneda != null ? compradorDepositanteMadreMoneda.hashCode() : 0);
        result = 31 * result + (compradorComitenteMoneda != null ? compradorComitenteMoneda.hashCode() : 0);
        result = 31 * result + (compradorCbuCvu != null ? compradorCbuCvu.hashCode() : 0);
        result = 31 * result + (agenteCbu != null ? agenteCbu.hashCode() : 0);
        result = 31 * result + (agenteDepositanteMadreMoneda != null ? agenteDepositanteMadreMoneda.hashCode() : 0);
        result = 31 * result + (agenteComitenteMoneda != null ? agenteComitenteMoneda.hashCode() : 0);
        result = 31 * result + (fechaHoraConcertacion != null ? fechaHoraConcertacion.hashCode() : 0);
        result = 31 * result + (idFceCdv != null ? idFceCdv.hashCode() : 0);
        result = 31 * result + (idFce != null ? idFce.hashCode() : 0);
        result = 31 * result + (referenciaPago != null ? referenciaPago.hashCode() : 0);
        result = 31 * result + (monedaFce != null ? monedaFce.hashCode() : 0);
        result = 31 * result + (valorNominalFce != null ? valorNominalFce.hashCode() : 0);
        result = 31 * result + (monedaNegociacion != null ? monedaNegociacion.hashCode() : 0);
        result = 31 * result + (compradorMonto != null ? compradorMonto.hashCode() : 0);
        result = 31 * result + (compradorComisionGastos != null ? compradorComisionGastos.hashCode() : 0);
        result = 31 * result + (vendedorComisionGastos != null ? vendedorComisionGastos.hashCode() : 0);
        result = 31 * result + (vendedorMonto != null ? vendedorMonto.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (ackStatus != null ? ackStatus.hashCode() : 0);
        result = 31 * result + (ackStatusMessage != null ? ackStatusMessage.hashCode() : 0);
        return result;
    }
}
