package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpBussinesUnit implements Serializable {

    private String biller;
    private String payerCode;
    private String shiptoCode;
    private String creditGranted;
    private String credit;
    private String attrib1;
    private String attrib2;
    private String comment;

    @JsonProperty("biller")
    @Size(max = 4)
    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    @JsonProperty("payerCode")
    @Size(max = 10)
    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    @JsonProperty("shiptoCode")
    @Size(max = 10)
    public String getShiptoCode() {
        return shiptoCode;
    }

    public void setShiptoCode(String shiptoCode) {
        this.shiptoCode = shiptoCode;
    }

	@JsonProperty("creditGranted")
	@Size(max = 10)
	public String getCreditGranted() {
		return creditGranted;
	}

	public void setCreditGranted(String creditGranted) { this.creditGranted = creditGranted; }

	@JsonProperty("credit")
	@Size(max = 10)
	public String getCredit() {
		return credit;
	}

	public void setCredit(String credit) { this.credit = credit; }

	@JsonProperty("attrib1")
	@Size(max = 10)
	public String getAttrib1() {
		return attrib1;
	}

	public void setAttrib1(String attrib1) { this.attrib1 = attrib1; }

	@JsonProperty("attrib2")
	@Size(max = 10)
	public String getAttrib2() {
		return attrib2;
	}

	public void setAttrib2(String attrib2) { this.attrib2 = attrib2; }

	@JsonProperty("comment")
	@Size(max = 10)
	public String getComment() {
		return comment;
	}

	public void setComment(String comment) { this.comment = comment; }

    @Override
    public String toString() {
        return "ErpBussinesUnit ["
                + ((biller != null) ? "biller=" + biller + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((shiptoCode != null) ? "shiptoCode=" + shiptoCode : "")
				+ ((creditGranted != null) ? "creditGranted=" + creditGranted : "")
				+ ((credit != null) ? "credit=" + credit : "")
				+ ((attrib1 != null) ? "attrib1=" + attrib1 : "")
				+ ((attrib2 != null) ? "attrib2=" + attrib2 : "")
				+ ((comment != null) ? "comment=" + comment : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpBussinesUnit erpBussinesUnit = (ErpBussinesUnit) o;
        return Objects.equals(biller, erpBussinesUnit.biller)
				&& Objects.equals(payerCode, erpBussinesUnit.payerCode)
				&& Objects.equals(shiptoCode, erpBussinesUnit.shiptoCode)
				&& Objects.equals(creditGranted, erpBussinesUnit.creditGranted)
				&& Objects.equals(credit, erpBussinesUnit.credit)
				&& Objects.equals(attrib1, erpBussinesUnit.attrib1)
				&& Objects.equals(attrib2, erpBussinesUnit.attrib2)
				&& Objects.equals(comment, erpBussinesUnit.comment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(biller, payerCode, shiptoCode, creditGranted, credit, attrib1, attrib2, comment);
    }
}