package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDistributor implements Serializable {

    private String taxId;
    private String name;

    @JsonProperty("taxId")
    @Size(max = 15)
    public String getTaxId() {
        return taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    @JsonProperty("name")
    @Size(max = 40)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "ErpDistributor ["
                + ((taxId != null) ? "taxId=" + taxId + ", " : "")
                + ((name != null) ? "name=" + name : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpDistributor erpDistributor = (ErpDistributor) o;
        return Objects.equals(taxId, erpDistributor.taxId) && Objects.equals(name, erpDistributor.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taxId, name);
    }
}