package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpDocument implements Serializable {

    public enum ErpStatus {
        CREATE,
        UPDATE,
        DELETE
    }

    public enum StatusEnum {
        O, //Open
        C, //Closed
        R, //Reversed
        H  //Historico
    }

    private String ownerType;
    private String ownerCode;
    private String payerCuit;
    private String payerCode;
    private String operatorEmail;
    private String operatorName;
    private String operatorDescription;
    private String ownerDocRef;
    private String legalDocRef;
    private String currency;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private String finalCurrency;
    private BigDecimal finalDueAmount;
    private String comments;
    private ErpStatus erpStatus;
    private String accountCode;
    private String areaCode;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creationDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'", timezone = "GMT+00:00")
    private Date creationTimestampUtc;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate;
    private String shiptoCode;
    private BigDecimal totalAmountUSD;
    private BigDecimal dueAmountUSD;
    private BigDecimal dueAmountRate;
    private BigDecimal finantialDiscount1;
    private StatusEnum status;
    private String gl;
    private String assignmentNumber;
    private String issuerAccountReference;
    private String linkedDocument;
    private String pmCode;
    private String pmDesc;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate;
    private String clearingOwnerDocRef;
    private String refNumber;
    private String termName1;
    private String distributorTaxId;
    private String salesPerson;
    private String sellingCondition;
    //Datos para medios de pago
    private String orderNumber;

    @Size(max = 10)
    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    @Size(max = 10)
    public String getOwnerCode() {
        return ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    @Size(max = 11)
    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    @Size(max = 100)
    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    @Size(max = 100)
    public String getOperatorEmail() {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.operatorEmail = operatorEmail;
    }

    @Size(max = 100)
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    @Size(max = 100)
    public String getOperatorDescription() {
        return operatorDescription;
    }

    public void setOperatorDescription(String operatorDescription) {
        this.operatorDescription = operatorDescription;
    }

    @Size(max = 255)
    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    @Size(max = 255)
    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    @Size(max = 3)
    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    @Size(max = 3)
    public String getFinalCurrency() {
        return finalCurrency;
    }

    public void setFinalCurrency(String finalCurrency) {
        this.finalCurrency = finalCurrency;
    }

    public BigDecimal getFinalDueAmount() {
        return finalDueAmount;
    }

    public void setFinalDueAmount(BigDecimal finalDueAmount) {
        this.finalDueAmount = finalDueAmount;
    }

    @Size(max = 500)
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Size(max = 50)
    public ErpStatus getErpStatus() {
        return erpStatus;
    }

    public void setErpStatus(ErpStatus erpStatus) {
        this.erpStatus = erpStatus;
    }

    @Size(max = 50)
    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    @Size(max = 50)
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @Size(max = 10)
    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Size(max = 10)
    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    @Size(max = 10)
    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getCreationTimestampUtc() {
        return creationTimestampUtc;
    }

    public void setCreationTimestampUtc(Date creationTimestampUtc) {
        this.creationTimestampUtc = creationTimestampUtc;
    }

    @Size(max = 100)
    public String getShiptoCode() {
        return shiptoCode;
    }

    public void setShiptoCode(String shiptoCode) {
        this.shiptoCode = shiptoCode;
    }

    public BigDecimal getTotalAmountUSD() {
        return totalAmountUSD;
    }

    public void setTotalAmountUSD(BigDecimal totalAmountUSD) {
        this.totalAmountUSD = totalAmountUSD;
    }

    public BigDecimal getDueAmountUSD() {
        return dueAmountUSD;
    }

    public void setDueAmountUSD(BigDecimal dueAmountUSD) {
        this.dueAmountUSD = dueAmountUSD;
    }

    public BigDecimal getDueAmountRate() {
        return dueAmountRate;
    }

    public void setDueAmountRate(BigDecimal dueAmountRate) {
        this.dueAmountRate = dueAmountRate;
    }

    public BigDecimal getFinantialDiscount1() {
        return finantialDiscount1;
    }

    public void setFinantialDiscount1(BigDecimal finantialDiscount1) {
        this.finantialDiscount1 = finantialDiscount1;
    }

    @Size(max = 1)
    public StatusEnum getStatus() {
        return status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @Size(max = 3)
    public String getGl() {
        return gl;
    }

    public void setGl(String gl) {
        this.gl = gl;
    }

    @Size(max = 20)
    public String getAssignmentNumber() {
        return assignmentNumber;
    }

    public void setAssignmentNumber(String assignmentNumber) {
        this.assignmentNumber = assignmentNumber;
    }

    @Size(max = 3)
    public String getIssuerAccountReference() {
        return issuerAccountReference;
    }

    public void setIssuerAccountReference(String issuerAccountReference) {
        this.issuerAccountReference = issuerAccountReference;
    }

    @Size(max = 20)
    public String getLinkedDocument() {
        return linkedDocument;
    }

    public void setLinkedDocument(String linkedDocument) {
        this.linkedDocument = linkedDocument;
    }

    @Size(max = 1)
    public String getPmCode() {
        return pmCode;
    }

    public void setPmCode(String pmCode) {
        this.pmCode = pmCode;
    }

    @Size(max = 30)
    public String getPmDesc() {
        return pmDesc;
    }

    public void setPmDesc(String pmDesc) {
        this.pmDesc = pmDesc;
    }

    @Size(max = 10)
    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    @Size(max = 30)
    public String getClearingOwnerDocRef() {
        return clearingOwnerDocRef;
    }

    public void setClearingOwnerDocRef(String clearingOwnerDocRef) {
        this.clearingOwnerDocRef = clearingOwnerDocRef;
    }

    @Size(max = 20)
    public String getRefNumber() {
        return refNumber;
    }

    public void setRefNumber(String refNumber) {
        this.refNumber = refNumber;
    }

    @Size(max = 1)
    public String getTermName1() {
        return termName1;
    }

    public void setTermName1(String termName1) {
        this.termName1 = termName1;
    }

    @Size(max = 15)
    public String getDistributorTaxId() {
        return distributorTaxId;
    }

    public void setDistributorTaxId(String distributorTaxId) {
        this.distributorTaxId = distributorTaxId;
    }

    @Size(max = 15)
    public String getSalesPerson() {
        return salesPerson;
    }

    public void setSalesPerson(String salesPerson) {
        this.salesPerson = salesPerson;
    }

    @Size(max = 15)
    public String getSellingCondition() {
        return sellingCondition;
    }

    public void setSellingCondition(String sellingCondition) {
        this.sellingCondition = sellingCondition;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Override
    public String toString() {
        return "ErpDocument [" +
                ((ownerType != null) ? "ownerType='" + ownerType + "', " : "") +
                ((ownerCode != null) ? "ownerCode='" + ownerCode + "', " : "") +
                ((payerCuit != null) ? "payerCuit='" + payerCuit + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((operatorEmail != null) ? "operatorEmail='" + operatorEmail + "', " : "") +
                ((operatorName != null) ? "operatorName='" + operatorName + "', " : "") +
                ((operatorDescription != null) ? "operatorDescription='" + operatorDescription + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "") +
                ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "") +
                ((finalCurrency != null) ? "finalCurrency='" + finalCurrency + "', " : "") +
                ((finalDueAmount != null) ? "finalDueAmount=" + finalDueAmount + ", " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((erpStatus != null) ? "erpStatus=" + erpStatus + ", " : "") +
                ((accountCode != null) ? "accountCode='" + accountCode + "', " : "") +
                ((areaCode != null) ? "areaCode='" + areaCode + "', " : "") +
                ((creationDate != null) ? "creationDate=" + creationDate + ", " : "") +
                ((creationTimestampUtc != null) ? "creationTimestampUtc=" + creationTimestampUtc + ", " : "") +
                ((issueDate != null) ? "issueDate=" + issueDate + ", " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((shiptoCode != null) ? "shiptoCode='" + shiptoCode + "', " : "") +
                ((totalAmountUSD != null) ? "totalAmountUSD=" + totalAmountUSD + ", " : "") +
                ((dueAmountUSD != null) ? "dueAmountUSD=" + dueAmountUSD + ", " : "") +
                ((dueAmountRate != null) ? "dueAmountRate=" + dueAmountRate + ", " : "") +
                ((finantialDiscount1 != null) ? "finantialDiscount1=" + finantialDiscount1 + ", " : "") +
                ((status != null) ? "status=" + status + ", " : "") +
                ((gl != null) ? "gl='" + gl + "', " : "") +
                ((assignmentNumber != null) ? "assignmentNumber='" + assignmentNumber + "', " : "") +
                ((issuerAccountReference != null) ? "issuerAccountReference='" + issuerAccountReference + "', " : "") +
                ((linkedDocument != null) ? "linkedDocument='" + linkedDocument + "', " : "") +
                ((pmCode != null) ? "pmCode='" + pmCode + "', " : "") +
                ((pmDesc != null) ? "pmDesc='" + pmDesc + "', " : "") +
                ((creditDate != null) ? "creditDate=" + creditDate + ", " : "") +
                ((clearingOwnerDocRef != null) ? "clearingOwnerDocRef='" + clearingOwnerDocRef + "', " : "") +
                ((refNumber != null) ? "refNumber='" + refNumber + "', " : "") +
                ((termName1 != null) ? "termName1='" + termName1 + "', " : "") +
                ((distributorTaxId != null) ? "distributorTaxId='" + distributorTaxId + "', " : "") +
                ((salesPerson != null) ? "salesPerson='" + salesPerson + "', " : "") +
                ((sellingCondition != null) ? "sellingCondition='" + sellingCondition + "', " : "") +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpDocument that = (ErpDocument) o;
        return Objects.equals(ownerType, that.ownerType) && Objects.equals(ownerCode, that.ownerCode) && Objects.equals(payerCuit, that.payerCuit) && Objects.equals(payerCode, that.payerCode) && Objects.equals(operatorEmail, that.operatorEmail) && Objects.equals(operatorName, that.operatorName) && Objects.equals(operatorDescription, that.operatorDescription) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(currency, that.currency) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(dueAmount, that.dueAmount) && Objects.equals(finalCurrency, that.finalCurrency) && Objects.equals(finalDueAmount, that.finalDueAmount) && Objects.equals(comments, that.comments) && erpStatus == that.erpStatus && Objects.equals(accountCode, that.accountCode) && Objects.equals(areaCode, that.areaCode) && Objects.equals(creationDate, that.creationDate) && Objects.equals(creationTimestampUtc, that.creationTimestampUtc) && Objects.equals(issueDate, that.issueDate) && Objects.equals(dueDate, that.dueDate) && Objects.equals(shiptoCode, that.shiptoCode) && Objects.equals(totalAmountUSD, that.totalAmountUSD) && Objects.equals(dueAmountUSD, that.dueAmountUSD) && Objects.equals(dueAmountRate, that.dueAmountRate) && Objects.equals(finantialDiscount1, that.finantialDiscount1) && status == that.status && Objects.equals(gl, that.gl) && Objects.equals(assignmentNumber, that.assignmentNumber) && Objects.equals(issuerAccountReference, that.issuerAccountReference) && Objects.equals(linkedDocument, that.linkedDocument) && Objects.equals(pmCode, that.pmCode) && Objects.equals(pmDesc, that.pmDesc) && Objects.equals(creditDate, that.creditDate) && Objects.equals(clearingOwnerDocRef, that.clearingOwnerDocRef) && Objects.equals(refNumber, that.refNumber) && Objects.equals(termName1, that.termName1) && Objects.equals(distributorTaxId, that.distributorTaxId) && Objects.equals(salesPerson, that.salesPerson) && Objects.equals(sellingCondition, that.sellingCondition) && Objects.equals(orderNumber, that.orderNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ownerType, ownerCode, payerCuit, payerCode, operatorEmail, operatorName, operatorDescription, ownerDocRef, legalDocRef, currency, totalAmount, dueAmount, finalCurrency, finalDueAmount, comments, erpStatus, accountCode, areaCode, creationDate, creationTimestampUtc, issueDate, dueDate, shiptoCode, totalAmountUSD, dueAmountUSD, dueAmountRate, finantialDiscount1, status, gl, assignmentNumber, issuerAccountReference, linkedDocument, pmCode, pmDesc, creditDate, clearingOwnerDocRef, refNumber, termName1, distributorTaxId, salesPerson, sellingCondition, orderNumber);
    }
}