package ar.com.sdd.ebfapi.api.account;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.api.company.CompanyEbfApiService;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/account")
public class AccountEbfApiEndpoint {

    @Inject
    private AccountEbfApiService accountEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/bank-accounts-search")
    @Produces("application/json; charset=utf-8")
    public Response getBankAccountsSearch(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                 @QueryParam("alias") String alias, @QueryParam("cbu") String cbu, @Context SecurityContext securityContext) {
        return accountEbfApiService.getBankAccountsSearch(authorization, applicationId, ownerId, alias, cbu, securityContext);
    }

}
