package ar.com.sdd.ebfapi.privateapi;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.NotificationEbfApi;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/private/")
public class NotificationPrivateEbfApiEndpoint {

    @Inject
    private NotificationPrivateEbfApiService service;

    @POST
    @ServerFileLogged
    @Path("/notification")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postNotification(@HeaderParam("Authorization") String authorization, NotificationEbfApi notificationEbfApi, @Context SecurityContext securityContext) {
        return service.notification(authorization, notificationEbfApi, securityContext);
    }
}