/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.ebfapi.api.account;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.api.account.AccountEbfApiService;
import ar.com.sdd.ebfapi.client.model.CompanyAccountEbfApi;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/ebfapi/v1_1/account")
public class AccountEbfApiEndpoint {
    @Inject
    private AccountEbfApiService accountEbfApiService;

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/bank-accounts-search")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getBankAccountsSearch(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @QueryParam(value="alias") String alias, @QueryParam(value="cbu") String cbu, @Context SecurityContext securityContext) {
        return this.accountEbfApiService.getBankAccountsSearch(authorization, applicationId, ownerId, alias, cbu, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/fiserv-cards")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getFiservCards(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @QueryParam(value="cuit") String fiservCardAccountOwnerCuit, @Context SecurityContext securityContext) {
        return this.accountEbfApiService.getFiservCards(authorization, aid, ownerId, fiservCardAccountOwnerCuit, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/fiserv-cards")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response postFiservCard(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, CompanyAccountEbfApi fiservCardAccount, @Context SecurityContext securityContext) {
        return this.accountEbfApiService.postFiservCard(authorization, aid, ownerId, fiservCardAccount, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/fiserv-cards/{fiservCardAccountId}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteFiservCard(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String aid, @PathParam(value="ownerId") String ownerId, @PathParam(value="fiservCardAccountId") String fiservCardAccountId, @Context SecurityContext securityContext) {
        return this.accountEbfApiService.deleteFiservCard(authorization, aid, ownerId, fiservCardAccountId, securityContext);
    }
}

