package ar.com.sdd.ebfapi.api.contrato.inba;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.io.contrato.inba.DeudaRequest;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/contrato-inba")
public class ContratoInbaDeudaEbfApiEndpoint {

    @Inject private ContratoInbaDeudaEbfApiService contratoInbaDeudaEbfApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/deudas")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postDeuda(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, DeudaRequest deudaRequest, @Context SecurityContext securityContext) {
        return contratoInbaDeudaEbfApiService.postDeuda(authorization, applicationId, ownerId, deudaRequest, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/deudas/{identificadorDeuda}")
    @Produces("application/json; charset=utf-8")
    public Response deleteDeuda(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("identificadorDeuda") Long identificadorDeuda, @Context SecurityContext securityContext) {
        return contratoInbaDeudaEbfApiService.deleteDeuda(authorization, applicationId, ownerId, identificadorDeuda, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/deudas/{identificadorDeuda}")
    @Produces("application/json; charset=utf-8")
    public Response getDeuda(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("identificadorDeuda") Long identificadorDeuda, @Context SecurityContext securityContext) {
        return contratoInbaDeudaEbfApiService.getDeuda(authorization, applicationId, ownerId, identificadorDeuda, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/deudas/rendiciones")
    @Produces("application/json; charset=utf-8")
    public Response getRendiciones(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @QueryParam("fecha") String fecha, @QueryParam("moneda") String moneda, @QueryParam("tamano") Integer tamano, @QueryParam("pagina") Integer pagina, @Context SecurityContext securityContext) {
        return contratoInbaDeudaEbfApiService.getRendiciones(authorization, applicationId, ownerId, fecha, moneda, tamano, pagina, securityContext);
    }

}
