package ar.com.sdd.ebfapi.api.actionlink;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.RedirectionActionLinkData;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/actionlink")
public class ActionLinkApiEndpoint {

    @Inject private ActionLinkApiService actionLinkApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/redirectLink")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postGenerateRedirectionActionLink(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, RedirectionActionLinkData redirectionActionLinkData, @Context SecurityContext securityContext) {
        return actionLinkApiService.postGenerateRedirectionActionLink(authorization, applicationId, ownerId, redirectionActionLinkData, securityContext);
    }
}
