package ar.com.sdd.ebfapi.api.dvp;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.dvp.DvpPaymentDocument;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/dvp-payment")
public class DvpPaymentEndpoint {

    @Inject
    private DvpPaymentService dvpPaymentService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/notify-dvp-payment")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postNotifyDvpPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, DvpPaymentDocument dvpPaymentDocument, @Context SecurityContext securityContext) {
        return dvpPaymentService.postNotifyDvpPayment(authorization, aid, ownerId, dvpPaymentDocument, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/dvp-payments/{paymentUid}")
    @Produces("application/json; charset=utf-8")
    public Response getDvpPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("paymentUid") String paymentUid, @Context SecurityContext securityContext) {
        return dvpPaymentService.getDvpPayment(authorization, aid, ownerId, paymentUid, securityContext);
    }

}
